/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.download.MavenGav;
import org.apache.camel.support.service.ServiceSupport;

public class CommandLineDependencyDownloader
extends ServiceSupport {
    private final CamelContext camelContext;
    private final DependencyDownloader downloader;
    private final String dependencies;

    public CommandLineDependencyDownloader(CamelContext camelContext, String dependencies) {
        this.camelContext = camelContext;
        this.dependencies = dependencies;
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
    }

    protected void doInit() throws Exception {
        this.downloadDependencies();
    }

    private void downloadDependencies() {
        ArrayList<Object> gavs = new ArrayList<Object>();
        for (String dep : this.dependencies.split(",")) {
            Object gav = dep;
            if (dep.startsWith("camel:") || dep.startsWith("camel-")) {
                gav = "org.apache.camel:camel-" + dep.substring(6) + ":" + this.camelContext.getVersion();
            }
            if (!this.isValidGav((String)gav)) continue;
            gavs.add(gav);
        }
        if (!gavs.isEmpty()) {
            for (String string : gavs) {
                MavenGav mg = MavenGav.parseGav(string, this.camelContext.getVersion());
                this.downloader.downloadDependency(mg.getGroupId(), mg.getArtifactId(), mg.getVersion());
            }
        }
    }

    private boolean isValidGav(String gav) {
        MavenGav mg = MavenGav.parseGav(gav, this.camelContext.getVersion());
        boolean exists = this.downloader.alreadyOnClasspath(mg.getGroupId(), mg.getArtifactId(), mg.getVersion());
        return !exists;
    }
}

