/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainRoutesLoader;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.download.KnownKameletRoutesBuilderLoader;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.RoutesBuilderLoader;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.service.ServiceHelper;

public class DependencyDownloaderRoutesLoader
extends MainRoutesLoader {
    private final DependencyDownloader downloader;

    public DependencyDownloaderRoutesLoader(CamelContext camelContext, MainConfigurationProperties configuration) {
        super(configuration);
        this.setCamelContext(camelContext);
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
    }

    protected RoutesBuilderLoader resolveService(String extension) {
        FactoryFinder finder;
        ExtendedCamelContext ecc;
        KnownKameletRoutesBuilderLoader loader;
        if ("groovy".equals(extension)) {
            this.downloadLoader("camel-groovy-dsl");
        } else if ("java".equals(extension)) {
            this.downloadLoader("camel-java-joor-dsl");
            this.downloadLoader("camel-endpointdsl");
        } else if ("js".equals(extension)) {
            this.downloadLoader("camel-js-dsl");
        } else if ("jsh".equals(extension)) {
            this.downloadLoader("camel-jsh-dsl");
        } else if ("kts".equals(extension)) {
            this.downloadLoader("camel-kotlin-dsl");
        } else if ("xml".equals(extension) || "camel.xml".equals(extension)) {
            this.downloadLoader("camel-xml-io-dsl");
        } else if ("yaml".equals(extension) || "kamelet.yaml".equals(extension) || "camel.yaml".equals(extension) || "camelk.yaml".equals(extension)) {
            this.downloadLoader("camel-yaml-dsl");
        }
        if ("kamelet.yaml".equals(extension)) {
            loader = new KnownKameletRoutesBuilderLoader();
            CamelContextAware.trySetCamelContext((Object)((Object)loader), (CamelContext)this.getCamelContext());
            this.initRoutesBuilderLoader((RoutesBuilderLoader)loader);
            ServiceHelper.startService((Object)((Object)loader));
        } else {
            loader = super.resolveService(extension);
        }
        if (loader == null && (loader = (RoutesBuilderLoader)ResolverHelper.resolveService((CamelContext)(ecc = (ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)), (FactoryFinder)(finder = ecc.getFactoryFinder("META-INF/services/org/apache/camel/routes-loader/")), (String)extension, RoutesBuilderLoader.class).orElse(null)) != null) {
            CamelContextAware.trySetCamelContext((Object)((Object)loader), (CamelContext)this.getCamelContext());
            this.initRoutesBuilderLoader((RoutesBuilderLoader)loader);
            ServiceHelper.startService((Object)((Object)loader));
        }
        return loader;
    }

    private void downloadLoader(String artifactId) {
        if (!this.downloader.alreadyOnClasspath("org.apache.camel", artifactId, this.getCamelContext().getVersion())) {
            this.downloader.downloadDependency("org.apache.camel", artifactId, this.getCamelContext().getVersion());
        }
    }
}

