/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import org.apache.camel.Component;
import org.apache.camel.component.stub.StubComponent;
import org.apache.camel.spi.Injector;

public class KameletMainInjector
implements Injector {
    private static final String ACCEPTED_STUB_NAMES = "StubComponent,BeanComponent,ClassComponent,KameletComponent,RestComponent,RestApiComponent,PlatformHttpComponent,VertxHttpComponent";
    private final Injector delegate;
    private final boolean stub;

    public KameletMainInjector(Injector delegate, boolean stub) {
        this.delegate = delegate;
        this.stub = stub;
    }

    public <T> T newInstance(Class<T> type) {
        boolean accept;
        if (this.stub && Component.class.isAssignableFrom(type) && !(accept = this.accept(type))) {
            return (T)this.delegate.newInstance(StubComponent.class);
        }
        return (T)this.delegate.newInstance(type);
    }

    public <T> T newInstance(Class<T> type, String factoryMethod) {
        boolean accept;
        if (this.stub && Component.class.isAssignableFrom(type) && !(accept = this.accept(type))) {
            return (T)this.delegate.newInstance(StubComponent.class);
        }
        return (T)this.delegate.newInstance(type, factoryMethod);
    }

    public <T> T newInstance(Class<T> type, boolean postProcessBean) {
        boolean accept;
        if (this.stub && Component.class.isAssignableFrom(type) && !(accept = this.accept(type))) {
            return (T)this.delegate.newInstance(StubComponent.class);
        }
        return (T)this.delegate.newInstance(type, postProcessBean);
    }

    public boolean supportsAutoWiring() {
        return this.delegate.supportsAutoWiring();
    }

    private boolean accept(Class<?> type) {
        if (!this.stub) {
            return true;
        }
        String shortName = type.getSimpleName();
        return ACCEPTED_STUB_NAMES.contains(shortName);
    }
}

