/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;

public final class KnownReposResolver {
    private final Map<String, String> repos = new HashMap<String, String>();
    private final CamelContext camelContext;

    public KnownReposResolver(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void loadKnownDependencies() {
        this.doLoadKnownRepos("/camel-main-known-repos.properties");
    }

    private void doLoadKnownRepos(String name) {
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is != null) {
                Properties prop = new Properties();
                prop.load(is);
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : prop.stringPropertyNames()) {
                    String value = prop.getProperty(key);
                    map.put(key, value);
                }
                this.addRepos(map);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addRepos(Map<String, String> repos) {
        this.repos.putAll(repos);
    }

    public String getRepo(String key) {
        return this.repos.get(key);
    }
}

