/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.main.download.ArtifactDownloadListener;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.DownloadException;
import org.apache.camel.main.download.DownloadListener;
import org.apache.camel.main.download.DownloadThreadPool;
import org.apache.camel.main.download.KnownReposResolver;
import org.apache.camel.main.download.MavenArtifact;
import org.apache.camel.main.download.MavenGav;
import org.apache.camel.main.injection.DIRegistry;
import org.apache.camel.main.util.VersionHelper;
import org.apache.camel.main.util.XmlHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.settings.io.DefaultSettingsReader;
import org.apache.maven.settings.io.DefaultSettingsWriter;
import org.apache.maven.settings.io.SettingsReader;
import org.apache.maven.settings.io.SettingsWriter;
import org.apache.maven.settings.validation.DefaultSettingsValidator;
import org.apache.maven.settings.validation.SettingsValidator;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultChecksumPolicyProvider;
import org.eclipse.aether.internal.impl.DefaultDeployer;
import org.eclipse.aether.internal.impl.DefaultFileProcessor;
import org.eclipse.aether.internal.impl.DefaultInstaller;
import org.eclipse.aether.internal.impl.DefaultLocalPathComposer;
import org.eclipse.aether.internal.impl.DefaultLocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import org.eclipse.aether.internal.impl.DefaultOfflineController;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import org.eclipse.aether.internal.impl.DefaultRepositoryLayoutProvider;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.DefaultTrackingFileManager;
import org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import org.eclipse.aether.internal.impl.DefaultUpdateCheckManager;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.internal.impl.checksum.DefaultChecksumAlgorithmFactorySelector;
import org.eclipse.aether.internal.impl.checksum.Md5ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollector;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector;
import org.eclipse.aether.internal.impl.collect.df.DfDependencyCollector;
import org.eclipse.aether.internal.impl.slf4j.Slf4jLoggerFactory;
import org.eclipse.aether.internal.impl.synccontext.legacy.DefaultSyncContextFactory;
import org.eclipse.aether.internal.impl.synccontext.named.GAVNameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactorySelector;
import org.eclipse.aether.internal.impl.synccontext.named.SimpleNamedLockFactorySelector;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.graph.traverser.FatArtifactTraverser;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.slf4j.Logger;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MavenDependencyDownloader
extends ServiceSupport
implements DependencyDownloader {
    public static final String MAVEN_CENTRAL_REPO = "https://repo1.maven.org/maven2";
    public static final String APACHE_SNAPSHOT_REPO = "https://repository.apache.org/snapshots";
    private static final Logger LOG = org.slf4j.LoggerFactory.getLogger(MavenDependencyDownloader.class);
    private static final String CP = System.getProperty("java.class.path");
    private static final String MINIMUM_QUARKUS_VERSION = "2.0.0";
    private static final RepositoryPolicy POLICY_DEFAULT = new RepositoryPolicy(true, "never", "warn");
    private static final RepositoryPolicy POLICY_FRESH = new RepositoryPolicy(true, "always", "warn");
    private static final RepositoryPolicy POLICY_DISABLED = new RepositoryPolicy(false, "never", "ignore");
    int customCount = 1;
    private String[] bootClasspath;
    private DownloadThreadPool threadPool;
    private DIRegistry registry;
    private ClassLoader classLoader;
    private CamelContext camelContext;
    private final Set<DownloadListener> downloadListeners = new LinkedHashSet<DownloadListener>();
    private final Set<ArtifactDownloadListener> artifactDownloadListeners = new LinkedHashSet<ArtifactDownloadListener>();
    private KnownReposResolver knownReposResolver;
    private String repos;
    private boolean fresh;
    private String mavenSettings;
    private String mavenSettingsSecurity;
    private RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private RemoteRepository apacheSnapshots;
    private boolean apacheSnapshotsIncluded;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public KnownReposResolver getKnownReposResolver() {
        return this.knownReposResolver;
    }

    public void setKnownReposResolver(KnownReposResolver knownReposResolver) {
        this.knownReposResolver = knownReposResolver;
    }

    @Override
    public void addDownloadListener(DownloadListener downloadListener) {
        CamelContextAware.trySetCamelContext((Object)downloadListener, (CamelContext)this.getCamelContext());
        this.downloadListeners.add(downloadListener);
    }

    @Override
    public void addArtifactDownloadListener(ArtifactDownloadListener downloadListener) {
        CamelContextAware.trySetCamelContext((Object)downloadListener, (CamelContext)this.getCamelContext());
        this.artifactDownloadListeners.add(downloadListener);
    }

    @Override
    public String getRepos() {
        return this.repos;
    }

    @Override
    public void setRepos(String repos) {
        this.repos = repos;
    }

    @Override
    public boolean isFresh() {
        return this.fresh;
    }

    @Override
    public void setFresh(boolean fresh) {
        this.fresh = fresh;
    }

    @Override
    public String getMavenSettings() {
        return this.mavenSettings;
    }

    @Override
    public void setMavenSettings(String mavenSettings) {
        this.mavenSettings = mavenSettings;
    }

    @Override
    public String getMavenSettingsSecurity() {
        return this.mavenSettingsSecurity;
    }

    @Override
    public void setMavenSettingsSecurity(String mavenSettingsSecurity) {
        this.mavenSettingsSecurity = mavenSettingsSecurity;
    }

    @Override
    public void downloadDependency(String groupId, String artifactId, String version) {
        this.downloadDependency(groupId, artifactId, version, true);
    }

    @Override
    public void downloadDependency(String groupId, String artifactId, String version, String extraRepos) {
        this.doDownloadDependency(groupId, artifactId, version, true, false, extraRepos);
    }

    @Override
    public void downloadHiddenDependency(String groupId, String artifactId, String version) {
        this.doDownloadDependency(groupId, artifactId, version, true, true, null);
    }

    @Override
    public void downloadDependency(String groupId, String artifactId, String version, boolean transitively) {
        this.doDownloadDependency(groupId, artifactId, version, transitively, false, null);
    }

    protected void doDownloadDependency(String groupId, String artifactId, String version, boolean transitively, boolean hidden, String extraRepos) {
        if (!hidden) {
            for (DownloadListener listener : this.downloadListeners) {
                listener.onDownloadDependency(groupId, artifactId, version);
            }
        }
        if (CP != null) {
            Object target = artifactId;
            if (version != null) {
                target = (String)target + "-" + version;
            }
            if (CP.contains((CharSequence)target)) {
                return;
            }
        }
        if (version == null) {
            return;
        }
        String gav = groupId + ":" + artifactId + ":" + version;
        this.threadPool.download(LOG, () -> {
            LOG.debug("Downloading: {}", (Object)gav);
            List<String> deps = List.of(gav);
            ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(this.remoteRepositories);
            if (!this.apacheSnapshotsIncluded && "org.apache.camel".equals(groupId) && version.contains("SNAPSHOT")) {
                repositories.add(this.apacheSnapshots);
            }
            ArrayList<RemoteRepository> extaRepositories = new ArrayList<RemoteRepository>();
            extaRepositories.addAll(this.resolveExtraRepositories(extraRepos));
            String known = this.knownReposResolver.getRepo(artifactId);
            extaRepositories.addAll(this.resolveExtraRepositories(known));
            repositories.addAll(extaRepositories);
            List<MavenArtifact> artifacts = this.resolveDependenciesViaAether(deps, repositories, transitively);
            ArrayList<File> files = new ArrayList<File>();
            LOG.debug("Resolved {} -> [{}]", (Object)gav, artifacts);
            for (MavenArtifact a : artifacts) {
                File file = a.getFile();
                if (this.alreadyOnClasspath(a.getGav().getGroupId(), a.getGav().getArtifactId(), a.getGav().getVersion(), false)) continue;
                if (this.classLoader instanceof DependencyDownloaderClassLoader) {
                    DependencyDownloaderClassLoader dependencyDownloaderClassLoader = (DependencyDownloaderClassLoader)this.classLoader;
                    dependencyDownloaderClassLoader.addFile(file);
                }
                files.add(file);
                LOG.trace("Added classpath: {}", (Object)a.getGav());
            }
            for (File file : files) {
                for (ArtifactDownloadListener artifactDownloadListener : this.artifactDownloadListeners) {
                    artifactDownloadListener.onDownloadedFile(file);
                }
            }
            if (!artifacts.isEmpty()) {
                for (DownloadListener listener : this.downloadListeners) {
                    listener.onDownloadedDependency(groupId, artifactId, version);
                }
            }
            if (!extaRepositories.isEmpty()) {
                for (RemoteRepository repo : extaRepositories) {
                    for (DownloadListener downloadListener : this.downloadListeners) {
                        downloadListener.onExtraRepository(repo.getUrl());
                    }
                }
            }
        }, gav);
    }

    @Override
    public MavenArtifact downloadArtifact(String groupId, String artifactId, String version) {
        String gav = groupId + ":" + artifactId + ":" + version;
        LOG.debug("DownloadingArtifact: {}", (Object)gav);
        List<CallSite> deps = List.of(gav);
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(this.remoteRepositories);
        if (!this.apacheSnapshotsIncluded && "org.apache.camel".equals(groupId) && version.contains("SNAPSHOT")) {
            repositories.add(this.apacheSnapshots);
        }
        List<MavenArtifact> artifacts = this.resolveDependenciesViaAether(deps, repositories, false);
        LOG.debug("Resolved {} -> [{}]", (Object)gav, artifacts);
        if (artifacts.size() == 1) {
            return artifacts.get(0);
        }
        return null;
    }

    @Override
    public List<String[]> resolveAvailableVersions(String groupId, String artifactId, String minimumVersion, String repo) {
        List<RemoteRepository> extra;
        String gav = groupId + ":" + artifactId;
        LOG.debug("DownloadAvailableVersions: {}", (Object)gav);
        RemoteRepository repository = this.remoteRepositories.get(0);
        if (repo != null && !(extra = this.resolveExtraRepositories(repo)).isEmpty()) {
            repository = extra.get(0);
        }
        List<String[]> versions = this.resolveAvailableVersions(groupId, artifactId, minimumVersion, repository);
        return versions;
    }

    @Override
    public boolean alreadyOnClasspath(String groupId, String artifactId, String version) {
        return this.alreadyOnClasspath(groupId, artifactId, version, true);
    }

    private boolean alreadyOnClasspath(String groupId, String artifactId, String version, boolean listener) {
        if (artifactId == null) {
            return true;
        }
        Object target = artifactId;
        if (version != null) {
            target = (String)target + "-" + version;
        }
        if (this.bootClasspath != null) {
            for (String s : this.bootClasspath) {
                if (!s.contains((CharSequence)target)) continue;
                if (listener) {
                    for (DownloadListener dl : this.downloadListeners) {
                        dl.onDownloadDependency(groupId, artifactId, version);
                    }
                }
                return true;
            }
        }
        if (this.classLoader instanceof URLClassLoader) {
            Object urlTarget = groupId + "/" + artifactId;
            urlTarget = ((String)urlTarget).replace('.', '/');
            urlTarget = (String)urlTarget + "/" + version + "/" + (String)target + ".jar";
            urlTarget = FileUtil.normalizePath((String)urlTarget);
            URLClassLoader ucl = (URLClassLoader)this.classLoader;
            for (URL u : ucl.getURLs()) {
                String s = u.toString();
                if (!(s = FileUtil.normalizePath((String)s)).contains((CharSequence)urlTarget)) continue;
                if (listener) {
                    for (DownloadListener dl : this.downloadListeners) {
                        dl.onDownloadDependency(groupId, artifactId, version);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onLoadingKamelet(String name) {
        for (DownloadListener listener : this.downloadListeners) {
            listener.onLoadingKamelet(name);
        }
    }

    @Override
    public void onLoadingModeline(String key, String value) {
        for (DownloadListener listener : this.downloadListeners) {
            listener.onLoadingModeline(key, value);
        }
    }

    private List<RemoteRepository> resolveExtraRepositories(String extraRepos) {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        if (extraRepos != null) {
            HashSet<URL> repositoryURLs = new HashSet<URL>();
            for (String repo : extraRepos.split(",")) {
                try {
                    RepositoryPolicy releasePolicy;
                    URL url = new URL(repo);
                    if (url.getHost().equals("repo1.maven.org")) continue;
                    String id = "custom" + this.customCount++;
                    RepositoryPolicy repositoryPolicy = releasePolicy = this.fresh ? POLICY_FRESH : POLICY_DEFAULT;
                    if (!repositoryURLs.add(url)) continue;
                    if (url.getHost().equals("repository.apache.org") && url.getPath().contains("/snapshots")) {
                        this.apacheSnapshotsIncluded = true;
                        repositories.add(this.apacheSnapshots);
                        continue;
                    }
                    repositories.add(new RemoteRepository.Builder(id, "default", repo).setReleasePolicy(releasePolicy).setSnapshotPolicy(this.fresh ? POLICY_FRESH : POLICY_DEFAULT).build());
                }
                catch (MalformedURLException e) {
                    LOG.warn("Can't use {} URL: {}. Skipping.", new Object[]{repo, e.getMessage(), e});
                }
            }
        }
        return repositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBuild() throws Exception {
        if (this.classLoader == null && this.camelContext != null) {
            this.classLoader = this.camelContext.getApplicationContextClassLoader();
        }
        this.threadPool = new DownloadThreadPool();
        this.threadPool.setCamelContext(this.camelContext);
        ServiceHelper.buildService((Object)((Object)this.threadPool));
        this.registry = new DIRegistry();
        Properties systemProperties = new Properties();
        Properties properties = System.getProperties();
        synchronized (properties) {
            systemProperties.putAll((Map<?, ?>)System.getProperties());
        }
        this.validateMavenSettingsLocations();
        this.repositorySystem = this.configureRepositorySystem(this.registry, systemProperties, this.mavenSettingsSecurity);
        Settings settings = this.mavenConfiguration(this.registry, this.repositorySystem, systemProperties, this.mavenSettings);
        this.repositorySystemSession = this.configureRepositorySystemSession(this.registry, systemProperties, settings, new File(settings.getLocalRepository()));
        List<RemoteRepository> originalRepositories = this.configureRemoteRepositories(settings, this.repos, this.fresh);
        this.remoteRepositories.addAll(this.repositorySystem.newResolutionRepositories(this.repositorySystemSession, originalRepositories));
        this.apacheSnapshots = (RemoteRepository)this.repositorySystem.newResolutionRepositories(this.repositorySystemSession, Collections.singletonList(this.apacheSnapshots)).get(0);
    }

    protected void doInit() throws Exception {
        RuntimeMXBean mb = ManagementFactory.getRuntimeMXBean();
        if (mb != null) {
            this.bootClasspath = mb.getClassPath().split("[:|;]");
        }
        ServiceHelper.initService((Object)((Object)this.threadPool));
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)((Object)this.threadPool));
        if (this.registry != null) {
            this.registry.close();
        }
    }

    private void validateMavenSettingsLocations() {
        String m2settingsSecurity;
        if (this.mavenSettingsSecurity != null && !new File(this.mavenSettingsSecurity).isFile()) {
            LOG.warn("Can't access {}. Skipping Maven settings-security.xml configuration.", (Object)this.mavenSettingsSecurity);
            this.mavenSettingsSecurity = null;
        }
        boolean skip = false;
        if ("false".equalsIgnoreCase(this.mavenSettings)) {
            this.mavenSettings = null;
            this.mavenSettingsSecurity = null;
            skip = true;
        } else if (this.mavenSettings == null) {
            String m2settings = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "settings.xml";
            if (new File(m2settings).isFile()) {
                this.mavenSettings = m2settings;
            }
        } else {
            if (!new File(this.mavenSettings).isFile()) {
                LOG.warn("Can't access {}. Skipping Maven settings.xml configuration.", (Object)this.mavenSettings);
            }
            this.mavenSettings = null;
        }
        if (!skip && this.mavenSettingsSecurity == null && new File(m2settingsSecurity = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "settings-security.xml").isFile()) {
            this.mavenSettingsSecurity = m2settingsSecurity;
        }
    }

    public RepositorySystem configureRepositorySystem(DIRegistry registry, Properties systemProperties, String settingsSecurityLocation) {
        MavenDependencyDownloader.basicRepositorySystemConfiguration(registry, systemProperties);
        MavenDependencyDownloader.transportConfiguration(registry, systemProperties);
        MavenDependencyDownloader.settingsConfiguration(registry, settingsSecurityLocation);
        return registry.lookupByClass(RepositorySystem.class);
    }

    private static void basicRepositorySystemConfiguration(DIRegistry registry, Properties systemProperties) {
        registry.bind(RepositorySystem.class, DefaultRepositorySystem.class);
        registry.bind(VersionResolver.class, DefaultVersionResolver.class);
        registry.bind(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        registry.bind(ArtifactResolver.class, DefaultArtifactResolver.class);
        registry.bind(MetadataResolver.class, DefaultMetadataResolver.class);
        registry.bind(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        registry.bind(DependencyCollector.class, DefaultDependencyCollector.class);
        registry.bind(Installer.class, DefaultInstaller.class);
        registry.bind(Deployer.class, DefaultDeployer.class);
        registry.bind(LocalRepositoryProvider.class, DefaultLocalRepositoryProvider.class);
        registry.bind(SyncContextFactory.class, org.eclipse.aether.internal.impl.synccontext.DefaultSyncContextFactory.class);
        registry.bind(RemoteRepositoryManager.class, DefaultRemoteRepositoryManager.class);
        registry.bind(RepositoryEventDispatcher.class, DefaultRepositoryEventDispatcher.class);
        registry.bind(FileProcessor.class, DefaultFileProcessor.class);
        registry.bind(UpdateCheckManager.class, DefaultUpdateCheckManager.class);
        registry.bind(RepositoryConnectorProvider.class, DefaultRepositoryConnectorProvider.class);
        registry.bind(OfflineController.class, DefaultOfflineController.class);
        registry.bind("modelBuilder", ModelBuilder.class, new DefaultModelBuilderFactory().newInstance());
        registry.bind(DependencyCollectorDelegate.class, DfDependencyCollector.class);
        registry.bind(DependencyCollectorDelegate.class, BfDependencyCollector.class);
        registry.bind(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        registry.bind(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        registry.bind(LocalRepositoryManagerFactory.class, EnhancedLocalRepositoryManagerFactory.class);
        registry.bind(NamedLockFactorySelector.class, SimpleNamedLockFactorySelector.class);
        registry.bind(UpdatePolicyAnalyzer.class, DefaultUpdatePolicyAnalyzer.class);
        registry.bind(ChecksumPolicyProvider.class, DefaultChecksumPolicyProvider.class);
        registry.bind(TrackingFileManager.class, DefaultTrackingFileManager.class);
        registry.bind(NamedLockFactory.class, FileLockNamedLockFactory.class);
        registry.bind(NamedLockFactory.class, LocalReadWriteLockNamedLockFactory.class);
        registry.bind(NameMapper.class, GAVNameMapper.class);
        registry.bind(org.eclipse.aether.impl.SyncContextFactory.class, DefaultSyncContextFactory.class);
        registry.bind(LocalPathComposer.class, DefaultLocalPathComposer.class);
        registry.bind(LocalPathPrefixComposerFactory.class, DefaultLocalPathPrefixComposerFactory.class);
        registry.bind(LoggerFactory.class, Slf4jLoggerFactory.class);
    }

    private static void transportConfiguration(DIRegistry registry, Properties systemProperties) {
        registry.bind(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        registry.bind(TransporterProvider.class, DefaultTransporterProvider.class);
        registry.bind(TransporterFactory.class, WagonTransporterFactory.class);
        registry.bind("manualWagonProvider", WagonProvider.class, new WagonProvider(){

            public Wagon lookup(String roleHint) {
                switch (roleHint) {
                    case "file": {
                        return new FileWagon();
                    }
                    case "http": 
                    case "https": {
                        return new HttpWagon();
                    }
                }
                return null;
            }

            public void release(Wagon wagon) {
            }
        });
        registry.bind("manualWagonConfigurator", WagonConfigurator.class, (wagon, configuration) -> {});
        registry.bind(RepositoryLayoutProvider.class, DefaultRepositoryLayoutProvider.class);
        registry.bind(RepositoryLayoutFactory.class, Maven2RepositoryLayoutFactory.class);
        registry.bind(ChecksumAlgorithmFactorySelector.class, DefaultChecksumAlgorithmFactorySelector.class);
        registry.bind(ChecksumAlgorithmFactory.class, Md5ChecksumAlgorithmFactory.class);
        registry.bind(ChecksumAlgorithmFactory.class, Sha1ChecksumAlgorithmFactory.class);
    }

    private static void settingsConfiguration(DIRegistry registry, String localSettingsSecurity) {
        DefaultSecDispatcher securityDispatcher = new DefaultSecDispatcher((PlexusCipher)new DefaultPlexusCipher());
        securityDispatcher.setConfigurationFile(localSettingsSecurity);
        registry.bind("securityDispatcher", SecDispatcher.class, securityDispatcher);
        registry.bind(SettingsDecrypter.class, DefaultSettingsDecrypter.class);
        registry.bind(SettingsReader.class, DefaultSettingsReader.class);
        registry.bind(SettingsWriter.class, DefaultSettingsWriter.class);
        registry.bind(SettingsValidator.class, DefaultSettingsValidator.class);
        registry.bind(SettingsBuilder.class, DefaultSettingsBuilder.class);
    }

    public Settings mavenConfiguration(DIRegistry registry, RepositorySystem repositorySystem, Properties systemProperties, String mavenSettings) {
        Comparable<File> m2Repository;
        Settings settings;
        SettingsBuilder settingsBuilder = registry.lookupByClass(SettingsBuilder.class);
        DefaultSettingsBuildingRequest sbRequest = new DefaultSettingsBuildingRequest();
        sbRequest.setSystemProperties(systemProperties);
        if (mavenSettings != null) {
            sbRequest.setUserSettingsFile(new File(mavenSettings));
        }
        try {
            SettingsBuildingResult sbResult = settingsBuilder.build((SettingsBuildingRequest)sbRequest);
            settings = sbResult.getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            LOG.warn("Problem reading settings file {}: {}. Falling back to defaults.", new Object[]{mavenSettings, e.getMessage(), e});
            settings = new Settings();
        }
        String localRepository = System.getProperty("maven.repo.local");
        if (localRepository == null || "".equals(localRepository.trim())) {
            localRepository = settings.getLocalRepository();
        }
        if (localRepository == null || "".equals(localRepository.trim())) {
            m2Repository = Paths.get(System.getProperty("user.home"), ".m2/repository");
            if (!m2Repository.toFile().isDirectory()) {
                m2Repository = Paths.get(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
                m2Repository.toFile().mkdirs();
            }
            localRepository = m2Repository.toString();
        }
        m2Repository = new File(localRepository);
        settings.setLocalRepository(((File)m2Repository).getAbsolutePath());
        SettingsDecrypter decrypter = registry.lookupByClass(SettingsDecrypter.class);
        DefaultSettingsDecryptionRequest sdRequest = new DefaultSettingsDecryptionRequest(settings);
        SettingsDecryptionResult sdResult = decrypter.decrypt((SettingsDecryptionRequest)sdRequest);
        settings.setProxies(sdResult.getProxies());
        settings.setServers(sdResult.getServers());
        for (Map.Entry entry : settings.getProfilesAsMap().entrySet()) {
            String name = (String)entry.getKey();
            Profile profile = (Profile)entry.getValue();
            if (profile.getActivation() == null || !profile.getActivation().isActiveByDefault()) continue;
            settings.getActiveProfiles().add(name);
        }
        return settings;
    }

    public RepositorySystemSession configureRepositorySystemSession(DIRegistry registry, Properties systemProperties, Settings settings, File localRepository) {
        JreProxySelector proxySelector;
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession();
        if (settings.getProxies().isEmpty()) {
            proxySelector = new JreProxySelector();
        } else {
            proxySelector = new DefaultProxySelector();
            for (Proxy proxy : settings.getProxies()) {
                if (!proxy.isActive()) continue;
                String nonProxyHosts = proxy.getNonProxyHosts();
                AuthenticationBuilder builder = new AuthenticationBuilder();
                if (proxy.getUsername() != null) {
                    builder.addUsername(proxy.getUsername());
                    builder.addPassword(proxy.getPassword());
                }
                org.eclipse.aether.repository.Proxy proxyConfig = new org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), builder.build());
                ((DefaultProxySelector)proxySelector).add(proxyConfig, nonProxyHosts);
            }
        }
        HashMap<Object, Object> serverConfigurations = new HashMap<Object, Object>();
        DefaultAuthenticationSelector baseAuthenticationSelector = new DefaultAuthenticationSelector();
        ConservativeAuthenticationSelector authenticationSelector = new ConservativeAuthenticationSelector((AuthenticationSelector)baseAuthenticationSelector);
        for (Object server : settings.getServers()) {
            Authentication auth = new AuthenticationBuilder().addPrivateKey(server.getPrivateKey(), server.getPassphrase()).addUsername(server.getUsername()).addPassword(server.getPassword()).build();
            baseAuthenticationSelector.add(server.getId(), auth);
            if (server.getFilePermissions() != null) {
                serverConfigurations.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            }
            if (server.getDirectoryPermissions() != null) {
                serverConfigurations.put("aether.connector.perms.dirMode." + server.getId(), server.getFilePermissions());
            }
            if (!(server.getConfiguration() instanceof Xpp3Dom)) continue;
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            Xpp3Dom serverConfig = (Xpp3Dom)server.getConfiguration();
            Xpp3Dom httpHeaders = serverConfig.getChild("httpHeaders");
            if (httpHeaders != null) {
                for (Xpp3Dom httpHeader : httpHeaders.getChildren("property")) {
                    Xpp3Dom name = httpHeader.getChild("name");
                    String headerName = name.getValue();
                    Xpp3Dom value = httpHeader.getChild("value");
                    String headerValue = value.getValue();
                    headers.put(headerName, headerValue);
                }
            }
            serverConfigurations.put("aether.connector.http.headers." + server.getId(), headers);
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : settings.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        LocalRepositoryManagerFactory lrmFactory = registry.lookupByClass(LocalRepositoryManagerFactory.class);
        try {
            session.setLocalRepositoryManager(lrmFactory.newInstance((RepositorySystemSession)session, new LocalRepository(localRepository)));
        }
        catch (NoLocalRepositoryManagerException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        session.setDependencyTraverser((DependencyTraverser)new FatArtifactTraverser());
        session.setDependencyManager((DependencyManager)new ClassicDependencyManager());
        AndDependencySelector depFilter = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test", "provided"}), new OptionalDependencySelector(), new ExclusionDependencySelector()});
        session.setDependencySelector((DependencySelector)depFilter);
        ConflictResolver transformer = new ConflictResolver((ConflictResolver.VersionSelector)new NearestVersionSelector(), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        transformer = new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{transformer, new JavaDependencyContextRefiner()});
        session.setDependencyGraphTransformer((DependencyGraphTransformer)transformer);
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        stereotypes.add((ArtifactType)new DefaultArtifactType("pom"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("maven-plugin", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("jar", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ejb", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ejb-client", "jar", "client", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("test-jar", "jar", "tests", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("javadoc", "jar", "javadoc", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("java-source", "jar", "sources", "java", false, false));
        stereotypes.add((ArtifactType)new DefaultArtifactType("war", "war", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ear", "ear", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("rar", "rar", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("par", "par", "", "java", false, true));
        session.setArtifactTypeRegistry((ArtifactTypeRegistry)stereotypes);
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(true, true));
        session.setUserProperties(null);
        session.setSystemProperties((Map)systemProperties);
        session.setConfigProperties((Map)systemProperties);
        session.setConfigProperty("aether.connector.basic.threads", (Object)"4");
        session.setConfigProperty("aether.collector.impl", (Object)"df");
        session.setConfigProperty("aether.connector.connectTimeout", (Object)10000);
        session.setConfigProperty("aether.connector.requestTimeout", (Object)1800000);
        serverConfigurations.forEach((arg_0, arg_1) -> ((DefaultRepositorySystemSession)session).setConfigProperty(arg_0, arg_1));
        session.setProxySelector((ProxySelector)proxySelector);
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        session.setChecksumPolicy(null);
        session.setUpdatePolicy(null);
        session.setAuthenticationSelector((AuthenticationSelector)authenticationSelector);
        session.setOffline(false);
        session.setIgnoreArtifactDescriptorRepositories(true);
        session.setWorkspaceReader(null);
        return session;
    }

    public List<RemoteRepository> configureRemoteRepositories(Settings settings, String repos, boolean fresh) {
        URL url;
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        HashSet<URL> repositoryURLs = new HashSet<URL>();
        repositories.add(new RemoteRepository.Builder("central", "default", MAVEN_CENTRAL_REPO).setReleasePolicy(fresh ? POLICY_FRESH : POLICY_DEFAULT).setSnapshotPolicy(POLICY_DISABLED).build());
        this.apacheSnapshots = new RemoteRepository.Builder("apache-snapshot", "default", APACHE_SNAPSHOT_REPO).setReleasePolicy(POLICY_DISABLED).setSnapshotPolicy(fresh ? POLICY_FRESH : POLICY_DEFAULT).build();
        if (repos != null) {
            for (String repo : repos.split(",")) {
                try {
                    RepositoryPolicy releasePolicy;
                    url = new URL(repo);
                    if (url.getHost().equals("repo1.maven.org")) continue;
                    String id = "custom" + this.customCount++;
                    RepositoryPolicy repositoryPolicy = releasePolicy = fresh ? POLICY_FRESH : POLICY_DEFAULT;
                    if (!repositoryURLs.add(url)) continue;
                    if (url.getHost().equals("repository.apache.org") && url.getPath().contains("/snapshots")) {
                        this.apacheSnapshotsIncluded = true;
                        repositories.add(this.apacheSnapshots);
                        continue;
                    }
                    repositories.add(new RemoteRepository.Builder(id, "default", repo).setReleasePolicy(releasePolicy).setSnapshotPolicy(fresh ? POLICY_FRESH : POLICY_DEFAULT).build());
                }
                catch (MalformedURLException e) {
                    LOG.warn("Can't use {} URL: {}. Skipping.", new Object[]{repo, e.getMessage(), e});
                }
            }
        }
        for (String profile : settings.getActiveProfiles()) {
            for (Repository r : ((Profile)settings.getProfilesAsMap().get(profile)).getRepositories()) {
                try {
                    url = new URL(r.getUrl());
                    if (!repositoryURLs.add(url)) continue;
                    if (url.getHost().equals("repository.apache.org") && url.getPath().startsWith("/snapshots")) {
                        this.apacheSnapshotsIncluded = true;
                    }
                    RemoteRepository.Builder rb = new RemoteRepository.Builder(r.getId(), r.getLayout(), r.getUrl());
                    if (r.getReleases() == null) {
                        rb.setPolicy(fresh ? POLICY_FRESH : POLICY_DEFAULT);
                    }
                    if (r.getSnapshots() == null) {
                        rb.setSnapshotPolicy(POLICY_DISABLED);
                    }
                    repositories.add(rb.build());
                }
                catch (MalformedURLException e) {
                    LOG.warn("Can't use {} URL from Maven settings: {}. Skipping.", new Object[]{r.getUrl(), e.getMessage(), e});
                }
            }
        }
        return repositories;
    }

    public List<MavenArtifact> resolveDependenciesViaAether(List<String> depIds, boolean transitively) {
        return this.resolveDependenciesViaAether(depIds, this.remoteRepositories, transitively);
    }

    public List<MavenArtifact> resolveDependenciesViaAether(List<String> depIds, List<RemoteRepository> repositories, boolean transitively) {
        try {
            ArtifactTypeRegistry artifactTypeRegistry = this.repositorySystemSession.getArtifactTypeRegistry();
            ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>(depIds.size());
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRepositories(repositories);
            for (String depId : depIds) {
                ArtifactRequest ar = new ArtifactRequest();
                ar.setRepositories(repositories);
                ar.setArtifact(MavenGav.parseGav(depId, artifactTypeRegistry).getArtifact());
                requests.add(ar);
                Dependency dependency = new Dependency(ar.getArtifact(), "compile", Boolean.valueOf(false));
                collectRequest.addDependency(dependency);
            }
            Object filter = transitively ? new AcceptAllDependencyFilter() : new AcceptDirectDependencyFilter(requests);
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, (DependencyFilter)filter);
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
            return dependencyResult.getArtifactResults().stream().map(dr -> {
                String gav = dr.getArtifact().getGroupId() + ":" + dr.getArtifact().getArtifactId() + ":" + (String)(!"jar".equals(dr.getArtifact().getExtension()) ? dr.getArtifact().getExtension() + ":" : "") + (String)(!"".equals(dr.getArtifact().getClassifier()) ? dr.getArtifact().getClassifier() + ":" : "") + dr.getArtifact().getVersion();
                return new MavenArtifact(MavenGav.parseGav(gav, artifactTypeRegistry), dr.getArtifact().getFile());
            }).collect(Collectors.toList());
        }
        catch (DependencyResolutionException e) {
            String msg = "Cannot resolve dependencies in " + repositories.stream().map(RemoteRepository::getUrl).collect(Collectors.joining(", "));
            throw new DownloadException(msg, e);
        }
        catch (RuntimeException e) {
            throw new DownloadException("Unknown error occurred while trying to resolve dependencies", e);
        }
    }

    public List<String[]> resolveAvailableVersions(String groupId, String artifactId, String minimumVersion, RemoteRepository repository) {
        ArrayList<String[]> answer = new ArrayList<String[]>();
        try {
            MetadataRequest ar = new MetadataRequest();
            ar.setRepository(repository);
            ar.setFavorLocalRepository(false);
            ar.setMetadata((Metadata)new DefaultMetadata(groupId, artifactId, "maven-metadata.xml", Metadata.Nature.RELEASE));
            List result = this.repositorySystem.resolveMetadata(this.repositorySystemSession, List.of(ar));
            for (MetadataResult mr : result) {
                File f;
                if (!mr.isResolved() || mr.getMetadata().getFile() == null || !(f = mr.getMetadata().getFile()).exists() || !f.isFile()) continue;
                DocumentBuilderFactory dbf = XmlHelper.createDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(f);
                NodeList nl = dom.getElementsByTagName("version");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element node = (Element)nl.item(i);
                    String v = node.getTextContent();
                    if (v == null) continue;
                    if ("camel-spring-boot".equals(artifactId)) {
                        String sbv = null;
                        if (VersionHelper.isGE(v, minimumVersion)) {
                            sbv = this.resolveSpringBootVersionByCamelVersion(v, repository);
                        }
                        answer.add(new String[]{v, sbv});
                        continue;
                    }
                    if ("camel-quarkus-catalog".equals(artifactId)) {
                        String cv;
                        if (!VersionHelper.isGE(v, MINIMUM_QUARKUS_VERSION) || (cv = this.resolveCamelVersionByQuarkusVersion(v, repository)) == null || !VersionHelper.isGE(cv, minimumVersion)) continue;
                        answer.add(new String[]{cv, v});
                        continue;
                    }
                    answer.add(new String[]{v, null});
                }
            }
        }
        catch (Exception e) {
            String msg = "Cannot resolve available versions in " + repository.getUrl();
            throw new DownloadException(msg, e);
        }
        return answer;
    }

    private String resolveCamelVersionByQuarkusVersion(String quarkusVersion, RemoteRepository repository) throws Exception {
        String gav = "org.apache.camel.quarkus:camel-quarkus:pom:" + quarkusVersion;
        List<RemoteRepository> repos = repository == this.remoteRepositories.get(0) ? List.of(repository) : List.of(this.remoteRepositories.get(0), repository);
        try {
            DocumentBuilderFactory dbf;
            DocumentBuilder db;
            Document dom;
            NodeList nl;
            String name;
            File file;
            MavenArtifact ma;
            List<MavenArtifact> artifacts = this.resolveDependenciesViaAether(List.of(gav), repos, false);
            if (!artifacts.isEmpty() && (ma = artifacts.get(0)) != null && ma.getFile() != null && (file = new File(name = ma.getFile().getAbsolutePath())).exists() && (nl = (dom = (db = (dbf = XmlHelper.createDocumentBuilderFactory()).newDocumentBuilder()).parse(file)).getElementsByTagName("parent")).getLength() == 1) {
                Element node = (Element)nl.item(0);
                return node.getElementsByTagName("version").item(0).getTextContent();
            }
        }
        catch (DownloadException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private String resolveSpringBootVersionByCamelVersion(String camelVersion, RemoteRepository repository) throws Exception {
        DocumentBuilderFactory dbf;
        DocumentBuilder db;
        Document dom;
        NodeList nl;
        String name;
        File file;
        MavenArtifact ma;
        String gav = "org.apache.camel.springboot:spring-boot:pom:" + camelVersion;
        List<RemoteRepository> repos = repository == this.remoteRepositories.get(0) ? List.of(repository) : List.of(this.remoteRepositories.get(0), repository);
        List<MavenArtifact> artifacts = this.resolveDependenciesViaAether(List.of(gav), repos, false);
        if (!artifacts.isEmpty() && (ma = artifacts.get(0)) != null && ma.getFile() != null && (file = new File(name = ma.getFile().getAbsolutePath())).exists() && (nl = (dom = (db = (dbf = XmlHelper.createDocumentBuilderFactory()).newDocumentBuilder()).parse(file)).getElementsByTagName("properties")).getLength() > 0) {
            Element node = (Element)nl.item(0);
            return node.getElementsByTagName("spring-boot-version").item(0).getTextContent();
        }
        return null;
    }

    private static class AcceptDirectDependencyFilter
    implements DependencyFilter {
        private final List<ArtifactRequest> requests;

        public AcceptDirectDependencyFilter(List<ArtifactRequest> requests) {
            this.requests = requests;
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            Dependency dependency = node.getDependency();
            if (dependency == null) {
                return false;
            }
            Artifact current = dependency.getArtifact();
            for (ArtifactRequest ar : this.requests) {
                if (!current.getGroupId().equals(ar.getArtifact().getGroupId()) || !current.getArtifactId().equals(ar.getArtifact().getArtifactId()) || !current.getExtension().equals(ar.getArtifact().getExtension()) || !current.getClassifier().equals(ar.getArtifact().getClassifier())) continue;
                return true;
            }
            return false;
        }
    }

    private static class AcceptAllDependencyFilter
    implements DependencyFilter {
        private AcceptAllDependencyFilter() {
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            return true;
        }
    }
}

