/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.http;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StartupListener;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServer;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerConfiguration;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.main.util.CamelJBangSettingsHelper;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxHttpServer {
    static VertxPlatformHttpRouter router;
    static VertxPlatformHttpServer server;
    static PlatformHttpComponent phc;
    private static final Logger LOG;
    private static final AtomicBoolean REGISTERED;
    private static final AtomicBoolean CONSOLE;
    private static final AtomicBoolean HEALTH_CHECK;
    private static final AtomicBoolean UPLOAD;

    private VertxHttpServer() {
    }

    public static void setPlatformHttpComponent(PlatformHttpComponent phc) {
        VertxHttpServer.phc = phc;
    }

    public static void registerServer(CamelContext camelContext, boolean stub) {
        if (REGISTERED.compareAndSet(false, true)) {
            VertxHttpServer.doRegisterServer(camelContext, 8080, stub);
        }
    }

    public static void registerServer(CamelContext camelContext, int port, boolean stub) {
        if (REGISTERED.compareAndSet(false, true)) {
            VertxHttpServer.doRegisterServer(camelContext, port, stub);
        }
    }

    private static void doRegisterServer(final CamelContext camelContext, final int port, boolean stub) {
        CamelJBangSettingsHelper.writeSettings("camel.jbang.platform-http.port", "" + port);
        if (stub) {
            return;
        }
        try {
            VertxPlatformHttpServerConfiguration config = new VertxPlatformHttpServerConfiguration();
            config.setPort(port);
            server = new VertxPlatformHttpServer(config);
            camelContext.addService((Object)server);
            server.start();
            router = VertxPlatformHttpRouter.lookup((CamelContext)camelContext);
            if (phc == null) {
                phc = (PlatformHttpComponent)camelContext.getComponent("platform-http", PlatformHttpComponent.class);
            }
            camelContext.addStartupListener(new StartupListener(){
                private volatile Set<HttpEndpointModel> last;

                public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
                    camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

                        public boolean isEnabled(CamelEvent event) {
                            return event instanceof CamelEvent.CamelContextStartedEvent || event instanceof CamelEvent.RouteReloadedEvent;
                        }

                        public void notify(CamelEvent event) throws Exception {
                            CamelEvent.RouteReloadedEvent re;
                            if (event instanceof CamelEvent.RouteReloadedEvent && (re = (CamelEvent.RouteReloadedEvent)event).getIndex() < re.getTotal()) {
                                return;
                            }
                            Set endpoints = phc.getHttpEndpoints();
                            if (endpoints.isEmpty()) {
                                return;
                            }
                            if (last == null || last.size() != endpoints.size() || !last.containsAll(endpoints)) {
                                LOG.info("HTTP endpoints summary");
                                for (HttpEndpointModel u : endpoints) {
                                    String line = "http://0.0.0.0:" + port + u.getUri();
                                    if (u.getVerbs() != null) {
                                        line = line + " (" + u.getVerbs() + ")";
                                    }
                                    LOG.info("    {}", (Object)line);
                                }
                            }
                            last = new HashSet<HttpEndpointModel>(endpoints);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    public static void registerConsole(CamelContext camelContext) {
        if (CONSOLE.compareAndSet(false, true)) {
            VertxHttpServer.doRegisterConsole(camelContext);
        }
    }

    private static void doRegisterConsole(final CamelContext context) {
        Route dev = router.route("/q/dev");
        dev.method(HttpMethod.GET);
        dev.produces("text/plain");
        dev.produces("application/json");
        Route devSub = router.route("/q/dev/*");
        devSub.method(HttpMethod.GET);
        devSub.produces("text/plain");
        devSub.produces("application/json");
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                String id;
                int pos2;
                int pos1;
                String acp = ctx.request().getHeader("Accept");
                int n = pos1 = acp != null ? acp.indexOf("html") : Integer.MAX_VALUE;
                if (pos1 == -1) {
                    pos1 = Integer.MAX_VALUE;
                }
                int n2 = pos2 = acp != null ? acp.indexOf("json") : Integer.MAX_VALUE;
                if (pos2 == -1) {
                    pos2 = Integer.MAX_VALUE;
                }
                boolean html = pos1 < pos2;
                boolean json = pos2 < pos1;
                DevConsole.MediaType mediaType = json ? DevConsole.MediaType.JSON : DevConsole.MediaType.TEXT;
                ctx.response().putHeader("content-type", "text/plain");
                DevConsoleRegistry dcr = (DevConsoleRegistry)context.getExtension(DevConsoleRegistry.class);
                if (dcr == null || !dcr.isEnabled()) {
                    ctx.end("Developer Console is not enabled");
                    return;
                }
                String path = StringHelper.after((String)ctx.request().path(), (String)"/q/dev/");
                String s = path;
                if (s != null && s.contains("/")) {
                    s = StringHelper.before((String)s, (String)"/");
                }
                if ((id = s) == null || id.isEmpty() || id.equals("index")) {
                    StringBuilder sb = new StringBuilder();
                    JsonObject root = new JsonObject();
                    dcr.stream().forEach(c -> {
                        if (json) {
                            JsonObject jo = new JsonObject();
                            jo.put((Object)"id", (Object)c.getId());
                            jo.put((Object)"displayName", (Object)c.getDisplayName());
                            jo.put((Object)"description", (Object)c.getDescription());
                            root.put((Object)c.getId(), (Object)jo);
                        } else {
                            Object link = c.getId();
                            String eol = "\n";
                            if (html) {
                                link = "<a href=\"dev/" + (String)link + "\">" + c.getId() + "</a>";
                                eol = "<br/>\n";
                            }
                            sb.append((String)link).append(": ").append(c.getDescription()).append(eol);
                            if ("top".equals(c.getId())) {
                                link = ((String)link).replace("top", "top/*");
                                sb.append((String)link).append(": ").append("Display the top processors").append(eol);
                            }
                        }
                    });
                    if (sb.length() > 0) {
                        String out = sb.toString();
                        if (html) {
                            ctx.response().putHeader("content-type", "text/html");
                        }
                        ctx.end(out);
                    } else if (!root.isEmpty()) {
                        ctx.response().putHeader("content-type", "application/json");
                        String out = root.toJson();
                        ctx.end(out);
                    }
                } else {
                    HashMap<String, String> params = new HashMap<String, String>();
                    ctx.queryParams().forEach(params::put);
                    params.put("CamelHttpPath", path);
                    StringBuilder sb = new StringBuilder();
                    JsonObject root = new JsonObject();
                    dcr.stream().sorted((o1, o2) -> {
                        int p1 = id.indexOf(o1.getId());
                        int p2 = id.indexOf(o2.getId());
                        return Integer.compare(p1, p2);
                    }).forEach(c -> {
                        boolean include;
                        boolean bl = include = "all".equals(id) || c.getId().equalsIgnoreCase(id);
                        if (include && c.supportMediaType(mediaType)) {
                            Object out = c.call(mediaType, params);
                            if (out != null && mediaType == DevConsole.MediaType.TEXT) {
                                sb.append(c.getDisplayName()).append(":");
                                sb.append("\n\n");
                                sb.append(out);
                                sb.append("\n\n");
                            } else if (out != null && mediaType == DevConsole.MediaType.JSON) {
                                root.put((Object)c.getId(), out);
                            }
                        }
                    });
                    if (sb.length() > 0) {
                        String out = sb.toString();
                        ctx.end(out);
                    } else if (!root.isEmpty()) {
                        ctx.response().putHeader("content-type", "application/json");
                        String out = root.toJson();
                        ctx.end(out);
                    } else {
                        ctx.end("Developer Console not found: " + id);
                    }
                }
            }
        };
        dev.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        devSub.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        phc.addHttpEndpoint("/q/dev", null);
    }

    public static void registerHealthCheck(CamelContext camelContext) {
        if (HEALTH_CHECK.compareAndSet(false, true)) {
            VertxHttpServer.doRegisterHealthCheck(camelContext);
        }
    }

    private static void doRegisterHealthCheck(final CamelContext context) {
        final Route health = router.route("/q/health");
        health.method(HttpMethod.GET);
        health.produces("application/json");
        final Route live = router.route("/q/health/live");
        live.method(HttpMethod.GET);
        live.produces("application/json");
        final Route ready = router.route("/q/health/ready");
        ready.method(HttpMethod.GET);
        ready.produces("application/json");
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                boolean rdy;
                ctx.response().putHeader("content-type", "application/json");
                boolean all = ctx.currentRoute() == health;
                boolean liv = ctx.currentRoute() == live;
                boolean bl = rdy = ctx.currentRoute() == ready;
                Collection res = all ? HealthCheckHelper.invoke((CamelContext)context) : (liv ? HealthCheckHelper.invokeLiveness((CamelContext)context) : HealthCheckHelper.invokeReadiness((CamelContext)context));
                StringBuilder sb = new StringBuilder();
                sb.append("{\n");
                HealthCheckRegistry registry = HealthCheckRegistry.get((CamelContext)context);
                String level = ctx.request().getParam("exposureLevel");
                if (level == null) {
                    level = registry.getExposureLevel();
                }
                boolean up = HealthCheckHelper.isResultsUp((Collection)res, (boolean)rdy);
                if ("oneline".equals(level)) {
                    VertxHttpServer.healthCheckStatus(sb, up);
                } else if ("full".equals(level)) {
                    ArrayList<HealthCheck.Result> list = new ArrayList<HealthCheck.Result>(res);
                    VertxHttpServer.healthCheckDetails(sb, list, up);
                } else {
                    List<HealthCheck.Result> downs = res.stream().filter(r -> r.getState().equals((Object)HealthCheck.State.DOWN)).collect(Collectors.toList());
                    VertxHttpServer.healthCheckDetails(sb, downs, up);
                }
                sb.append("}\n");
                if (!up) {
                    ctx.response().setStatusCode(500);
                }
                ctx.end(sb.toString());
            }
        };
        health.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        live.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        ready.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        phc.addHttpEndpoint("/q/health", null);
    }

    private static void healthCheckStatus(StringBuilder sb, boolean up) {
        if (up) {
            sb.append("    \"status\": \"UP\"\n");
        } else {
            sb.append("    \"status\": \"DOWN\"\n");
        }
    }

    private static void healthCheckDetails(StringBuilder sb, List<HealthCheck.Result> checks, boolean up) {
        VertxHttpServer.healthCheckStatus(sb, up);
        if (!checks.isEmpty()) {
            sb.append(",\n");
            sb.append("    \"checks\": [\n");
            for (int i = 0; i < checks.size(); ++i) {
                HealthCheck.Result d = checks.get(i);
                sb.append("        {\n");
                VertxHttpServer.reportHealthCheck(sb, d);
                if (i < checks.size() - 1) {
                    sb.append("        },\n");
                    continue;
                }
                sb.append("        }\n");
            }
            sb.append("    ]\n");
        }
    }

    private static void reportHealthCheck(StringBuilder sb, HealthCheck.Result d) {
        sb.append("            \"name\": \"").append(d.getCheck().getId()).append("\",\n");
        sb.append("            \"status\": \"").append(d.getState()).append("\",\n");
        if (d.getError().isPresent()) {
            String msg = VertxHttpServer.allCausedByErrorMessages((Throwable)d.getError().get());
            sb.append("            \"error-message\": \"").append(msg).append("\",\n");
            sb.append("            \"error-stacktrace\": \"").append(VertxHttpServer.errorStackTrace((Throwable)d.getError().get())).append("\",\n");
        }
        if (d.getMessage().isPresent()) {
            sb.append("            \"message\": \"").append((String)d.getMessage().get()).append("\",\n");
        }
        if (d.getDetails() != null && !d.getDetails().isEmpty()) {
            Iterator it = new TreeSet(d.getDetails().keySet()).iterator();
            sb.append("            \"data\": {\n");
            while (it.hasNext()) {
                String k = (String)it.next();
                Object v = d.getDetails().get(k);
                if (v == null) {
                    v = "";
                }
                boolean last = !it.hasNext();
                sb.append("                 \"").append(k).append("\": \"").append(v).append("\"");
                if (!last) {
                    sb.append(",");
                }
                sb.append("\n");
            }
            sb.append("            }\n");
        }
    }

    private static String allCausedByErrorMessages(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        while (e.getCause() != null) {
            if ((e = e.getCause()).getMessage() == null) continue;
            sb.append("; Caused by: ");
            sb.append(ObjectHelper.classCanonicalName((Object)e));
            sb.append(": ");
            sb.append(e.getMessage());
        }
        return sb.toString();
    }

    private static String errorStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String trace = sw.toString();
        trace = trace.replace('\"', '\'');
        trace = trace.replace('\t', ' ');
        trace = trace.replace(System.lineSeparator(), " ");
        return trace;
    }

    public static void registerUploadSourceDir(CamelContext camelContext, String dir) {
        if (UPLOAD.compareAndSet(false, true)) {
            VertxHttpServer.doRegisterUploadSourceDir(camelContext, dir);
        }
    }

    private static void doRegisterUploadSourceDir(CamelContext context, final String dir) {
        Route upload = router.route("/q/upload/:filename").method(HttpMethod.PUT).handler((Handler)BodyHandler.create((boolean)true));
        Route uploadDelete = router.route("/q/upload/:filename");
        uploadDelete.method(HttpMethod.DELETE);
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handle(RoutingContext ctx) {
                int status;
                block7: {
                    int n;
                    File[] fileArray;
                    AntPathMatcher match;
                    String name;
                    block10: {
                        block8: {
                            block9: {
                                boolean delete;
                                name = ctx.pathParam("filename");
                                if (name == null) {
                                    ctx.response().setStatusCode(400);
                                    ctx.end();
                                    return;
                                }
                                status = 200;
                                boolean bl = delete = HttpMethod.DELETE == ctx.request().method();
                                if (!delete) break block8;
                                if (!name.contains("*")) break block9;
                                if (name.equals("*")) {
                                    name = "**";
                                }
                                match = AntPathMatcher.INSTANCE;
                                File[] files = new File(dir).listFiles();
                                if (files == null) break block7;
                                fileArray = files;
                                n = fileArray.length;
                                break block10;
                            }
                            File f = new File(dir, name);
                            if (!f.exists() || !f.isFile()) break block7;
                            LOG.info("Deleting file: {}/{}", (Object)dir, (Object)name);
                            FileUtil.deleteFile((File)f);
                            break block7;
                        }
                        File f = new File(dir, name);
                        boolean exists = f.isFile() && f.exists();
                        LOG.info("{} file: {}/{}", new Object[]{exists ? "Updating" : "Creating", dir, name});
                        File tmp = new File(dir, name + ".tmp");
                        FileOutputStream fos = null;
                        try {
                            fos = new FileOutputStream(tmp, false);
                            RequestBody rb = ctx.body();
                            IOHelper.writeText((String)rb.asString(), (OutputStream)fos);
                            FileUtil.renameFileUsingCopy((File)tmp, (File)f);
                            FileUtil.deleteFile((File)tmp);
                        }
                        catch (Exception e) {
                            try {
                                LOG.warn("Error saving file: {}/{} due to: {}", new Object[]{dir, name, e.getMessage(), e});
                                status = 500;
                            }
                            catch (Throwable throwable) {
                                IOHelper.close(fos);
                                FileUtil.deleteFile((File)tmp);
                                throw throwable;
                            }
                            IOHelper.close((Closeable)fos);
                            FileUtil.deleteFile((File)tmp);
                            break block7;
                        }
                        IOHelper.close((Closeable)fos);
                        FileUtil.deleteFile((File)tmp);
                        break block7;
                    }
                    for (int i = 0; i < n; ++i) {
                        File f = fileArray[i];
                        if (f.getName().startsWith(".") || f.isHidden() || !match.match(name, f.getName())) continue;
                        LOG.info("Deleting file: {}/{}", (Object)dir, (Object)name);
                        FileUtil.deleteFile((File)f);
                    }
                }
                ctx.response().setStatusCode(status);
                ctx.end();
            }
        };
        upload.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        uploadDelete.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        phc.addHttpEndpoint("/q/upload", "PUT,DELETE");
    }

    static {
        LOG = LoggerFactory.getLogger(VertxHttpServer.class);
        REGISTERED = new AtomicBoolean();
        CONSOLE = new AtomicBoolean();
        HEALTH_CHECK = new AtomicBoolean();
        UPLOAD = new AtomicBoolean();
    }
}

