/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.camel.support.SupplierRegistry;
import org.apache.camel.util.function.Suppliers;

public class DIRegistry
extends SupplierRegistry {
    private final Map<Class<?>, List<Object>> byClass = new HashMap();
    private final Set<Supplier<?>> underConstruction = Collections.synchronizedSet(new HashSet());

    public void bind(Class<?> type) {
        this.bind(type, type);
    }

    public void bind(Class<?> key, final Class<?> type) {
        String name = key.getName();
        for (Annotation annotation : type.getAnnotations()) {
            if (Named.class != annotation.annotationType() || (name = type.getAnnotation(Named.class).value()) != null && !"".equals(name.trim())) continue;
            name = key.getName();
        }
        Constructor<?> defaultConstructor = null;
        Comparator<Constructor> byParamCount = Comparator.comparingInt(Constructor::getParameterCount).reversed();
        TreeSet<Constructor> constructors = new TreeSet<Constructor>(byParamCount);
        for (Constructor<?> ctr : type.getDeclaredConstructors()) {
            if (ctr.getParameterCount() == 0) {
                defaultConstructor = ctr;
                continue;
            }
            if (ctr.getAnnotation(Inject.class) == null) continue;
            constructors.add(ctr);
        }
        if (constructors.isEmpty() && defaultConstructor != null) {
            try {
                Object obj = defaultConstructor.newInstance(new Object[0]);
                this.bind(name, key, obj);
                return;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                throw new IllegalArgumentException("Problem registering bean of " + type.getName() + " type");
            }
        }
        if (!constructors.isEmpty()) {
            final Constructor constructor = (Constructor)constructors.iterator().next();
            final Type[] parameterTypes = constructor.getGenericParameterTypes();
            Supplier<Object> lazyCreator = new Supplier<Object>(){

                @Override
                public Object get() {
                    if (DIRegistry.this.underConstruction.contains(this)) {
                        throw new IllegalStateException("Cyclic dependency found when creating bean of " + type.getName() + " type");
                    }
                    DIRegistry.this.underConstruction.add(this);
                    try {
                        Object[] parameters = new Object[parameterTypes.length];
                        int pc = 0;
                        for (Type pt : parameterTypes) {
                            Class t = null;
                            Cloneable param = null;
                            if (pt instanceof ParameterizedType) {
                                Class rawType = (Class)((ParameterizedType)pt).getRawType();
                                Type[] typeArguments = ((ParameterizedType)pt).getActualTypeArguments();
                                if (Collection.class.isAssignableFrom(rawType)) {
                                    if (typeArguments.length == 1) {
                                        Map values;
                                        Type vType = typeArguments[0];
                                        t = rawType;
                                        if (Set.class == rawType) {
                                            param = new LinkedHashSet();
                                            values = DIRegistry.this.findByTypeWithName((Class)vType);
                                            ((Set)((Object)param)).addAll(values.values());
                                        } else if (List.class == rawType) {
                                            param = new ArrayList();
                                            values = DIRegistry.this.findByTypeWithName((Class)vType);
                                            ((List)((Object)param)).addAll(values.values());
                                        }
                                    }
                                } else if (Map.class == rawType) {
                                    if (typeArguments.length == 2) {
                                        Type kType = typeArguments[0];
                                        Type vType = typeArguments[1];
                                        t = rawType;
                                        param = new LinkedHashMap();
                                        Map values = DIRegistry.this.findByTypeWithName((Class)vType);
                                        ((Map)((Object)param)).putAll(values);
                                    }
                                } else {
                                    t = rawType;
                                }
                            } else if (pt instanceof Class && (t = (Class)pt).isArray()) {
                                Map values = DIRegistry.this.findByTypeWithName(t.getComponentType());
                                param = Array.newInstance(t.getComponentType(), values.size());
                                System.arraycopy(values.values().toArray(), 0, param, 0, values.size());
                            }
                            if (t == null) {
                                throw new IllegalArgumentException("Can't handle argument of " + pt + " type when creating bean of " + type.getName() + " type");
                            }
                            if (param == null) {
                                List<Object> instances = DIRegistry.this.byClass.get(t);
                                if (instances == null) {
                                    throw new IllegalArgumentException("Missing " + t.getName() + " instance when creating bean of " + type.getName() + " type");
                                }
                                if (instances.size() > 1) {
                                    throw new IllegalArgumentException("Ambiguous parameter of " + t.getName() + " when creating bean of " + type.getName() + " type");
                                }
                                param = instances.get(0);
                            }
                            parameters[pc++] = param instanceof Supplier ? (LinkedHashSet)((Supplier)((Object)param)).get() : param;
                        }
                        try {
                            constructor.setAccessible(true);
                            Object t = constructor.newInstance(parameters);
                            return t;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                            throw new IllegalArgumentException("Problem instantiating bean of " + type.getName() + " type", exception);
                        }
                    }
                    finally {
                        DIRegistry.this.underConstruction.remove(this);
                    }
                }
            };
            this.bind(name, key, (Object)Suppliers.memorize((Supplier)lazyCreator));
        }
    }

    public void alias(Class<?> alias, Class<?> key) {
        if (this.byClass.containsKey(key)) {
            List<Object> recipes = this.byClass.get(key);
            this.byClass.put(alias, recipes);
            String id = alias.getName();
            if (recipes.size() > 1) {
                throw new IllegalArgumentException("Multiple recipes for " + key.getName() + " type");
            }
            ((Map)this.computeIfAbsent(id, k -> new LinkedHashMap())).put(alias, recipes.get(0));
        }
    }

    public void bind(String id, Class<?> type, Object bean) {
        this.byClass.computeIfAbsent(type, c -> new ArrayList()).add(bean);
        super.bind(id, type, bean);
    }

    public void bind(String id, Class<?> type, Supplier<Object> bean) {
        this.byClass.computeIfAbsent(type, c -> new ArrayList()).add(bean);
        super.bind(id, type, bean);
    }

    public void bindAsPrototype(String id, Class<?> type, Supplier<Object> bean) {
        this.byClass.computeIfAbsent(type, c -> new ArrayList()).add(bean);
        super.bindAsPrototype(id, type, bean);
    }

    public <T> T lookupByClass(Class<T> cls) {
        List<Object> instances = this.byClass.get(cls);
        if (instances == null) {
            return null;
        }
        if (instances.size() > 1) {
            throw new IllegalArgumentException("Multiple beans of " + cls.getName() + " type available");
        }
        Object instance = instances.get(0);
        return (T)(instance instanceof Supplier ? ((Supplier)instance).get() : instance);
    }
}

