/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.download.KnownDependenciesResolver;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.ObjectHelper;

public final class DependencyDownloaderClassResolver
extends DefaultClassResolver {
    private final KnownDependenciesResolver knownDependenciesResolver;
    private final DependencyDownloader downloader;

    public DependencyDownloaderClassResolver(CamelContext camelContext, KnownDependenciesResolver knownDependenciesResolver) {
        super(camelContext);
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
        this.knownDependenciesResolver = knownDependenciesResolver;
    }

    public InputStream loadResourceAsStream(String uri) {
        MavenGav gav;
        InputStream answer = null;
        try {
            answer = super.loadResourceAsStream(uri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (answer == null && (gav = this.knownDependenciesResolver.mavenGavForClass(uri)) != null) {
            if (!this.downloader.alreadyOnClasspath(gav.getGroupId(), gav.getArtifactId(), gav.getVersion())) {
                this.downloader.downloadDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
            }
            try {
                answer = super.loadResourceAsStream(uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return answer;
    }

    protected Class<?> loadClass(String name, ClassLoader loader) {
        MavenGav gav;
        Class answer = null;
        try {
            answer = ObjectHelper.loadClass((String)name, (ClassLoader)loader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (answer == null && (gav = this.knownDependenciesResolver.mavenGavForClass(name)) != null) {
            if (!this.downloader.alreadyOnClasspath(gav.getGroupId(), gav.getArtifactId(), gav.getVersion())) {
                this.downloader.downloadDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
            }
            try {
                answer = ObjectHelper.loadClass((String)name, (ClassLoader)loader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return answer;
    }
}

