/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.engine.DefaultResourceLoader;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.StringHelper;

public class DependencyDownloaderResourceLoader
extends DefaultResourceLoader {
    private final DependencyDownloader downloader;
    private final String sourceDir;

    public DependencyDownloaderResourceLoader(CamelContext camelContext, String sourceDir) {
        super(camelContext);
        this.sourceDir = sourceDir;
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
    }

    public Resource resolveResource(String uri) {
        String scheme = StringHelper.before((String)uri, (String)":");
        if (("github".equals(scheme) || "gist".equals(scheme)) && !this.hasResourceResolver(scheme) && !this.downloader.alreadyOnClasspath("org.apache.camel", "camel-resourceresolver-github", this.getCamelContext().getVersion())) {
            this.downloader.downloadDependency("org.apache.camel", "camel-resourceresolver-github", this.getCamelContext().getVersion());
        }
        Resource answer = super.resolveResource((String)uri);
        if (this.sourceDir != null) {
            boolean exists;
            boolean bl = exists = answer != null && answer.exists();
            if (!exists && ("classpath".equals(scheme) || "file".equals(scheme))) {
                String path = StringHelper.after((String)uri, (String)":");
                if (path.startsWith("//")) {
                    path = path.substring(2);
                }
                uri = "file:" + this.sourceDir + File.separator + path;
                answer = super.resolveResource((String)uri);
            }
        }
        return answer;
    }
}

