/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public final class ExtraFilesClassLoader
extends ClassLoader {
    final List<String> files;

    public ExtraFilesClassLoader(ClassLoader parent, List<String> files) {
        super(parent);
        this.files = files;
    }

    @Override
    protected URL findResource(String name) {
        return this.getResource(name);
    }

    @Override
    public URL getResource(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        for (String f : this.files) {
            String source = f;
            if (source.startsWith("src/main/resources/")) {
                source = source.substring(19);
            } else if (source.startsWith("src\\main\\resources\\")) {
                source = source.substring(19);
            }
            if (!name.equals(source)) continue;
            try {
                return new File(f).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return null;
    }
}

