/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.xml.spring;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.model.Model;
import org.apache.camel.model.app.RegistryBeanDefinition;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.metrics.StartupStep;
import org.w3c.dom.Document;

public class SpringXmlBeansHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SpringXmlBeansHandler.class);
    private static final Pattern SPRING_PATTERN = Pattern.compile("\\$\\{(.*?)}");
    private final List<String> delayedBeans = new LinkedList<String>();
    private final Set<String> infraBeanNames = Set.of("CamelContext", "MainConfiguration");

    public void processSpringBeans(CamelContext camelContext, MainConfigurationProperties config, Map<String, Document> xmls) {
        LOG.debug("Loading beans from classic Spring <beans> XML");
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        beanFactory.setAllowCircularReferences(true);
        beanFactory.setBeanClassLoader(camelContext.getApplicationContextClassLoader());
        beanFactory.setBeanExpressionResolver((value, beanExpressionContext) -> this.extractValue(camelContext, value, true));
        camelContext.getRegistry().bind("SpringBeanFactory", (Object)beanFactory);
        beanFactory.registerSingleton("CamelContext", (Object)camelContext);
        beanFactory.registerSingleton("MainConfiguration", (Object)config);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        xmls.forEach((id, doc) -> reader.registerBeanDefinitions(doc, (Resource)new AbstractResource((String)id){
            final /* synthetic */ String val$id;
            {
                this.val$id = string;
            }

            public String getFilename() {
                if (this.val$id.startsWith("camel-xml-io-dsl-spring-xml:")) {
                    return StringHelper.afterLast((String)this.val$id, (String)":");
                }
                return null;
            }

            public String getDescription() {
                return this.val$id;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(new byte[0]);
            }
        }));
        beanFactory.freezeConfiguration();
        List<String> beanNames = Arrays.asList(beanFactory.getBeanDefinitionNames());
        LOG.info("Discovered {} Spring XML <beans>", (Object)beanNames.size());
        this.instantiateAndRegisterBeans(camelContext, beanFactory, beanNames);
    }

    public void createAndRegisterBeans(CamelContext camelContext) {
        if (this.delayedBeans.isEmpty()) {
            return;
        }
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)camelContext.getRegistry().lookupByNameAndType("SpringBeanFactory", DefaultListableBeanFactory.class);
        for (String beanName : this.delayedBeans) {
            AbstractBeanDefinition abd;
            BeanDefinition bd = beanFactory.getMergedBeanDefinition(beanName);
            if (!(bd instanceof AbstractBeanDefinition) || (abd = (AbstractBeanDefinition)bd).hasBeanClass()) continue;
            Class c = camelContext.getClassResolver().resolveClass(abd.getBeanClassName());
            abd.setBeanClass(c);
        }
        this.instantiateAndRegisterBeans(camelContext, beanFactory, this.delayedBeans);
    }

    private void instantiateAndRegisterBeans(CamelContext camelContext, DefaultListableBeanFactory beanFactory, List<String> beanNames) {
        LinkedList<String> instantiatedBeanNames = new LinkedList<String>();
        for (String beanName : beanNames) {
            BeanDefinition bd = beanFactory.getMergedBeanDefinition(beanName);
            if (bd.isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
            try {
                if (beanFactory.isFactoryBean(beanName)) {
                    SmartFactoryBean smartFactoryBean;
                    Object bean = beanFactory.getBean("&" + beanName);
                    if (!(bean instanceof SmartFactoryBean) || !(smartFactoryBean = (SmartFactoryBean)bean).isEagerInit()) continue;
                    beanFactory.getBean(beanName);
                    instantiatedBeanNames.add(beanName);
                    continue;
                }
                beanFactory.getBean(beanName);
                instantiatedBeanNames.add(beanName);
            }
            catch (CannotLoadBeanClassException ignored) {
                this.delayedBeans.add(beanName);
            }
        }
        for (String beanName : instantiatedBeanNames) {
            Object singletonInstance = beanFactory.getSingleton(beanName);
            if (!(singletonInstance instanceof SmartInitializingSingleton)) continue;
            SmartInitializingSingleton smartSingleton = (SmartInitializingSingleton)singletonInstance;
            StartupStep smartInitialize = beanFactory.getApplicationStartup().start("spring.beans.smart-initialize").tag("beanName", beanName);
            smartSingleton.afterSingletonsInstantiated();
            smartInitialize.end();
        }
        for (String name : instantiatedBeanNames) {
            if (this.infraBeanNames.contains(name)) continue;
            BeanDefinition def = beanFactory.getBeanDefinition(name);
            if (def.isSingleton()) {
                camelContext.getRegistry().bind(name, beanFactory.getBean(name));
            } else {
                camelContext.getRegistry().bind(name, () -> beanFactory.getBean(name));
            }
            this.addBeanToCamelModel(camelContext, name, def);
        }
    }

    private void addBeanToCamelModel(CamelContext camelContext, String name, BeanDefinition def) {
        Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        if (model != null) {
            String fn;
            GenericBeanDefinition gbd;
            Resource res;
            RegistryBeanDefinition rrd = new RegistryBeanDefinition();
            if (def instanceof GenericBeanDefinition && (res = (gbd = (GenericBeanDefinition)def).getResource()) != null && (fn = res.getFilename()) != null) {
                rrd.setResource(((ResourceLoader)camelContext.getCamelContextExtension().getContextPlugin(ResourceLoader.class)).resolveResource("file:" + fn));
            }
            rrd.setType(def.getBeanClassName());
            rrd.setName(name);
            LOG.debug("Adding Spring <beans> XML bean: {} to DSL model", (Object)name);
            model.addRegistryBean(rrd);
            if (def.getFactoryBeanName() != null) {
                rrd.setFactoryBean(def.getFactoryBeanName());
            }
            if (def.getFactoryMethodName() != null) {
                rrd.setFactoryMethod(def.getFactoryMethodName());
            }
            if (def.getInitMethodName() != null) {
                rrd.setInitMethod(def.getInitMethodName());
            }
            if (def.getDestroyMethodName() != null) {
                rrd.setDestroyMethod(def.getDestroyMethodName());
            }
            if (def.hasConstructorArgumentValues()) {
                LinkedHashMap<Integer, Object> constructors = new LinkedHashMap<Integer, Object>();
                rrd.setConstructors(constructors);
                ConstructorArgumentValues ctrs = def.getConstructorArgumentValues();
                for (int i = 0; i < ctrs.getArgumentCount(); ++i) {
                    ConstructorArgumentValues.ValueHolder vh = ctrs.getArgumentValue(i, Object.class);
                    if (vh == null) continue;
                    Object val = vh.getValue();
                    if (val instanceof TypedStringValue) {
                        TypedStringValue tsv = (TypedStringValue)val;
                        constructors.put(i, this.extractValue(camelContext, tsv.getValue(), false));
                        continue;
                    }
                    if (!(val instanceof BeanReference)) continue;
                    BeanReference br = (BeanReference)val;
                    constructors.put(i, "#bean:" + this.extractValue(camelContext, br.getBeanName(), false));
                }
            }
            if (def.hasPropertyValues()) {
                LinkedHashMap<Object, Object> properties = new LinkedHashMap<Object, Object>();
                rrd.setProperties(properties);
                MutablePropertyValues values = def.getPropertyValues();
                for (PropertyValue v : values) {
                    String key = v.getName();
                    PropertyValue src = v.getOriginalPropertyValue();
                    Object val = src.getValue();
                    if (val instanceof TypedStringValue) {
                        TypedStringValue tsv = (TypedStringValue)val;
                        properties.put(key, this.extractValue(camelContext, tsv.getValue(), false));
                        continue;
                    }
                    if (val instanceof BeanReference) {
                        BeanReference br = (BeanReference)val;
                        properties.put(key, "#bean:" + this.extractValue(camelContext, br.getBeanName(), false));
                        continue;
                    }
                    if (val instanceof List) {
                        int i = 0;
                        Iterator it = ObjectHelper.createIterator((Object)val);
                        while (it.hasNext()) {
                            String k = key + "[" + i + "]";
                            val = it.next();
                            if (val instanceof TypedStringValue) {
                                TypedStringValue tsv = (TypedStringValue)val;
                                properties.put(k, this.extractValue(camelContext, tsv.getValue(), false));
                            } else if (val instanceof BeanReference) {
                                BeanReference br = (BeanReference)val;
                                properties.put(k, "#bean:" + this.extractValue(camelContext, br.getBeanName(), false));
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!(val instanceof Map)) continue;
                    Map map = (Map)val;
                    for (Map.Entry entry : map.entrySet()) {
                        String k = key + "[" + ((TypedStringValue)entry.getKey()).getValue() + "]";
                        val = entry.getValue();
                        if (val instanceof TypedStringValue) {
                            TypedStringValue tsv = (TypedStringValue)val;
                            properties.put(k, this.extractValue(camelContext, tsv.getValue(), false));
                            continue;
                        }
                        if (!(val instanceof BeanReference)) continue;
                        BeanReference br = (BeanReference)val;
                        properties.put(k, "#bean:" + this.extractValue(camelContext, br.getBeanName(), false));
                    }
                }
            }
        }
    }

    protected String extractValue(CamelContext camelContext, String val, boolean resolve) {
        if (val != null && val.contains("${")) {
            Matcher matcher = SPRING_PATTERN.matcher(val);
            while (matcher.find()) {
                String replace = "{{" + matcher.group(1) + "}}";
                val = matcher.replaceFirst(replace);
                matcher.reset(val);
            }
        }
        if (resolve && camelContext != null) {
            val = camelContext.resolvePropertyPlaceholders(val);
        }
        return val;
    }

    public void stop() {
    }
}

