/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Service;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.main.MainHttpServer;
import org.apache.camel.component.stub.StubComponent;
import org.apache.camel.impl.engine.DefaultComponentResolver;
import org.apache.camel.main.HttpServerConfigurationProperties;
import org.apache.camel.main.MainHttpServerFactory;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.util.CamelJBangSettingsHelper;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.tooling.model.ComponentModel;

public final class DependencyDownloaderComponentResolver
extends DefaultComponentResolver {
    private static final String ACCEPTED_STUB_NAMES = "stub,bean,class,direct,kamelet,log,platform-http,rest,rest-api,seda,vertx-http";
    private final CamelCatalog catalog = new DefaultCamelCatalog();
    private final CamelContext camelContext;
    private final DependencyDownloader downloader;
    private final String stubPattern;
    private final boolean silent;

    public DependencyDownloaderComponentResolver(CamelContext camelContext, String stubPattern, boolean silent) {
        this.camelContext = camelContext;
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
        this.stubPattern = stubPattern;
        this.silent = silent;
    }

    public Component resolveComponent(String name, CamelContext context) {
        List<String> suggestion;
        MainHttpServer server;
        boolean accept;
        ComponentModel model = this.catalog.componentModel(name);
        if (model != null) {
            this.downloadLoader(model.getGroupId(), model.getArtifactId(), model.getVersion());
        }
        Component answer = (accept = this.accept(name)) ? super.resolveComponent(name, context) : super.resolveComponent("stub", context);
        if ((this.silent || this.stubPattern != null) && answer instanceof StubComponent) {
            StubComponent sc = (StubComponent)answer;
            sc.setShadow(true);
            sc.setShadowPattern(this.stubPattern);
        }
        if (answer instanceof PlatformHttpComponent && (server = (MainHttpServer)this.camelContext.hasService(MainHttpServer.class)) == null) {
            HttpServerConfigurationProperties config = new HttpServerConfigurationProperties(null);
            CamelJBangSettingsHelper.writeSettings("camel.jbang.platform-http.port", String.valueOf(config.getPort()));
            if (!this.silent) {
                try {
                    MainHttpServerFactory factory = DependencyDownloaderComponentResolver.resolveMainHttpServerFactory(this.camelContext);
                    Service httpServer = factory.newHttpServer(config);
                    this.camelContext.addService((Object)httpServer, true, true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (answer == null && (suggestion = SuggestSimilarHelper.didYouMean(this.catalog.findComponentNames(), name)) != null && !suggestion.isEmpty()) {
            String s = String.join((CharSequence)", ", suggestion);
            throw new IllegalArgumentException("Cannot find component with name: " + name + ". Did you mean: " + s);
        }
        return answer;
    }

    private void downloadLoader(String groupId, String artifactId, String version) {
        if (!this.downloader.alreadyOnClasspath(groupId, artifactId, version)) {
            this.downloader.downloadDependency(groupId, artifactId, version);
        }
    }

    private boolean accept(String name) {
        if (this.stubPattern == null) {
            return true;
        }
        return ACCEPTED_STUB_NAMES.contains(name);
    }

    private static MainHttpServerFactory resolveMainHttpServerFactory(CamelContext camelContext) throws Exception {
        MainHttpServerFactory answer = (MainHttpServerFactory)camelContext.getRegistry().findSingleByType(MainHttpServerFactory.class);
        if (answer == null) {
            answer = (MainHttpServerFactory)camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("platform-http-server", MainHttpServerFactory.class).orElseThrow(() -> new IllegalArgumentException("Cannot find MainHttpServerFactory on classpath. Add camel-platform-http-main to classpath."));
        }
        return answer;
    }
}

