/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.camel.processor.DefaultClaimCheckRepository;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.ClaimCheckRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.support.processor.state.MemoryStateRepository;

public class StubBeanRepository
implements BeanRepository {
    private final String stubPattern;

    public StubBeanRepository(String stubPattern) {
        this.stubPattern = stubPattern;
    }

    public Object lookupByName(String name) {
        return null;
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        if (PatternHelper.matchPattern((String)name, (String)this.stubPattern)) {
            return this.stubType(type);
        }
        return null;
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        T answer;
        if (this.stubPattern != null && (answer = this.stubType(type)) != null) {
            String name = UUID.randomUUID().toString();
            return Map.of(name, answer);
        }
        return Collections.EMPTY_MAP;
    }

    public <T> Set<T> findByType(Class<T> type) {
        T answer;
        if (this.stubPattern != null && (answer = this.stubType(type)) != null) {
            return Set.of(answer);
        }
        return Collections.EMPTY_SET;
    }

    private <T> T stubType(Class<T> type) {
        if (IdempotentRepository.class.isAssignableFrom(type)) {
            return (T)new MemoryIdempotentRepository();
        }
        if (AggregationRepository.class.isAssignableFrom(type)) {
            return (T)new MemoryAggregationRepository();
        }
        if (ClaimCheckRepository.class.isAssignableFrom(type)) {
            return (T)new DefaultClaimCheckRepository();
        }
        if (StateRepository.class.isAssignableFrom(type)) {
            return (T)new MemoryStateRepository();
        }
        return null;
    }
}

