/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.spi.annotations.PeriodicTask;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;

@PeriodicTask(value="clipboard-reload-strategy")
public class ClipboardReloadStrategy
extends ServiceSupport
implements CamelContextAware,
Runnable {
    private CamelContext camelContext;
    private final File file;
    private String content;

    public ClipboardReloadStrategy(File file) {
        this.file = file;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        if (this.file.exists()) {
            try (FileInputStream fis = new FileInputStream(this.file);){
                this.content = IOHelper.loadText((InputStream)fis);
            }
        }
    }

    @Override
    public void run() {
        try {
            String text;
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            Object t = c.getData(DataFlavor.stringFlavor);
            if (!(t == null || (text = t.toString()) == null || text.isBlank() || this.content != null && text.compareTo(this.content) == 0)) {
                IOHelper.writeText((String)text, (File)this.file);
                this.content = text;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

