/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.util;

import java.io.File;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.util.StringHelper;

public class ExtraClassesClassLoader
extends ClassLoader {
    private final Map<String, byte[]> classes = new HashMap<String, byte[]>();

    public ExtraClassesClassLoader(ClassLoader classLoader, List<String> names) {
        super(classLoader);
        for (String n : names) {
            this.addClass(new File(n));
        }
    }

    public void addClass(File file) {
        try {
            byte[] data = Files.readAllBytes(file.toPath());
            String name = file.getPath();
            name = name.replace('/', '.').replace('\\', '.');
            name = name.replace(".class", "");
            this.classes.put(name, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String simple;
        byte[] bytes = this.classes.get(name);
        if (bytes == null && (simple = StringHelper.afterLast((String)name, (String)".")) != null && (bytes = this.classes.get(simple)) != null) {
            this.classes.put(name, bytes);
            this.classes.remove(simple);
        }
        if (bytes == null) {
            return super.findClass(name);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

