/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.component.kamelet.KameletComponent;
import org.apache.camel.component.kamelet.KameletEndpoint;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.DefaultConsumer;

final class KameletConsumer
extends DefaultConsumer
implements ShutdownAware,
Suspendable {
    private final KameletComponent component;
    private final String key;

    public KameletConsumer(KameletEndpoint endpoint, Processor processor, String key) {
        super((Endpoint)endpoint, processor);
        this.component = endpoint.getComponent();
        this.key = key;
    }

    public KameletEndpoint getEndpoint() {
        return (KameletEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.component.addConsumer(this.key, this);
    }

    protected void doStop() throws Exception {
        this.component.removeConsumer(this.key, this);
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        this.component.removeConsumer(this.key, this);
    }

    protected void doResume() throws Exception {
        this.component.addConsumer(this.key, this);
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    public int getPendingExchangesSize() {
        return 0;
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
    }
}

