/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.spi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.spi.Configurer;

@Configurer
public final class KnativeResource {
    private String name;
    private String url;
    private Knative.Type type;
    private Knative.EndpointKind endpointKind;
    private Boolean reply;
    private String contentType;
    private String cloudEventType;
    private String path;
    private String objectApiVersion;
    private String objectKind;
    private String objectName;
    private Map<String, String> metadata;
    private Map<String, String> ceOverrides;
    private Map<String, String> filters;

    public String getName() {
        return this.name;
    }

    @JsonProperty(required=true)
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(required=true)
    public Knative.Type getType() {
        String stringValue;
        Knative.Type answer = this.type;
        if (answer == null && (stringValue = this.getMetadata("knative.type")) != null) {
            answer = Knative.Type.valueOf(stringValue);
        }
        return answer;
    }

    public void setType(Knative.Type type) {
        this.type = type;
    }

    public Knative.EndpointKind getEndpointKind() {
        String stringValue;
        Knative.EndpointKind answer = this.endpointKind;
        if (answer == null && (stringValue = this.getMetadata("camel.endpoint.kind")) != null) {
            answer = Knative.EndpointKind.valueOf(stringValue);
        }
        return answer;
    }

    public void setEndpointKind(Knative.EndpointKind endpointKind) {
        this.endpointKind = endpointKind;
    }

    public String getUrl() {
        return this.url != null ? this.url : this.getMetadata("service.url");
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @JsonIgnore
    public String getMetadata(String key) {
        return this.metadata != null ? this.metadata.get(key) : null;
    }

    public void setMetadata(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, value);
    }

    @JsonIgnore
    public Optional<String> getOptionalMetadata(String key) {
        return Optional.ofNullable(this.getMetadata(key));
    }

    public String getCloudEventType() {
        return this.cloudEventType != null ? this.cloudEventType : this.getMetadata("knative.event.type");
    }

    public void setCloudEventType(String cloudEventType) {
        this.cloudEventType = cloudEventType;
    }

    public String getPath() {
        return this.path != null ? this.path : this.getMetadata("service.path");
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getObjectApiVersion() {
        return this.objectApiVersion != null ? this.objectApiVersion : this.getMetadata("knative.apiVersion");
    }

    public void setObjectApiVersion(String objectApiVersion) {
        this.objectApiVersion = objectApiVersion;
    }

    public String getObjectKind() {
        return this.objectKind != null ? this.objectKind : this.getMetadata("knative.kind");
    }

    public void setObjectKind(String objectKind) {
        this.objectKind = objectKind;
    }

    public String getObjectName() {
        return this.objectName != null ? this.objectName : this.getMetadata("knative.name");
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public Map<String, String> getCeOverrides() {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (this.ceOverrides != null) {
            answer.putAll(this.ceOverrides);
        }
        if (this.metadata != null) {
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                if (!entry.getKey().startsWith("ce.override.")) continue;
                String key = entry.getKey().substring("ce.override.".length());
                String val = entry.getValue();
                answer.put(key, val);
            }
        }
        return answer;
    }

    public void setCeOverrides(Map<String, String> ceOverride) {
        this.ceOverrides = ceOverride;
    }

    public void addCeOverride(String key, String value) {
        if (this.ceOverrides == null) {
            this.ceOverrides = new HashMap<String, String>();
        }
        this.ceOverrides.put(key, value);
        this.ceOverrides.put(key, value);
    }

    public Map<String, String> getFilters() {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (this.filters != null) {
            answer.putAll(this.filters);
        }
        if (this.metadata != null) {
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                if (!entry.getKey().startsWith("filter.")) continue;
                String key = entry.getKey().substring("filter.".length());
                String val = entry.getValue();
                answer.put(key, val);
            }
        }
        return answer;
    }

    public void setFilters(Map<String, String> filters) {
        this.filters = filters;
    }

    public void addFilter(String key, String value) {
        if (this.filters == null) {
            this.filters = new HashMap<String, String>();
        }
        this.filters.put(key, value);
    }

    public Boolean getReply() {
        return this.reply != null ? this.reply : this.getOptionalMetadata("knative.reply").map(Boolean::parseBoolean).orElse(true);
    }

    public void setReply(Boolean reply) {
        this.reply = reply;
    }

    public String getContentType() {
        return this.contentType != null ? this.contentType : this.getMetadata("content.type");
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean matches(Knative.Type type, String name) {
        if (type == null || name == null) {
            return false;
        }
        return Objects.equals((Object)type, (Object)this.getType()) && Objects.equals(name, this.getName());
    }

    public String toString() {
        return "KnativeResource{name='" + this.name + "', url='" + this.url + "', metadata=" + this.metadata + ", ceOverrides=" + this.ceOverrides + ", filters=" + this.filters + ", type=" + this.type + ", endpointKind=" + this.endpointKind + ", reply=" + this.reply + ", contentType='" + this.contentType + "'}";
    }

    public static KnativeResource from(KnativeResource resource) {
        KnativeResource answer = new KnativeResource();
        answer.name = resource.name;
        answer.url = resource.url;
        answer.type = resource.type;
        answer.endpointKind = resource.endpointKind;
        answer.reply = resource.reply;
        answer.contentType = resource.contentType;
        answer.cloudEventType = resource.cloudEventType;
        answer.path = resource.path;
        if (resource.metadata != null) {
            answer.metadata = new HashMap<String, String>(resource.metadata);
        }
        if (resource.ceOverrides != null) {
            answer.ceOverrides = new HashMap<String, String>(resource.ceOverrides);
        }
        if (resource.filters != null) {
            answer.filters = new HashMap<String, String>(resource.filters);
        }
        return answer;
    }
}

