/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.http;

import io.vertx.core.http.HttpServerRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvent;
import org.apache.camel.component.knative.spi.KnativeResource;

public final class KnativeHttpSupport {
    private KnativeHttpSupport() {
    }

    public static void appendHeader(Map<String, Object> headers, String key, Object value) {
        if (headers.containsKey(key)) {
            ArrayList<Object> list;
            Object existing = headers.get(key);
            if (existing instanceof List) {
                list = (ArrayList<Object>)existing;
            } else {
                list = new ArrayList<Object>();
                list.add(existing);
            }
            list.add(value);
            value = list;
        }
        headers.put(key, value);
    }

    public static Predicate<HttpServerRequest> createFilter(CloudEvent cloudEvent, KnativeResource resource) {
        HashMap filters = new HashMap();
        for (Map.Entry entry : resource.getFilters().entrySet()) {
            cloudEvent.attribute((String)entry.getKey()).map(CloudEvent.Attribute::http).ifPresentOrElse(k -> filters.put(k, (String)entry.getValue()), () -> filters.put((String)entry.getKey(), (String)entry.getValue()));
        }
        return request -> {
            if (filters.isEmpty()) {
                return true;
            }
            for (Map.Entry entry : filters.entrySet()) {
                boolean matches;
                List values = request.headers().getAll((String)entry.getKey());
                if (values.isEmpty()) {
                    return false;
                }
                String val = (String)values.get(values.size() - 1);
                int idx = val.lastIndexOf(44);
                if (values.size() == 1 && idx != -1) {
                    val = val.substring(idx + 1);
                    val = val.trim();
                }
                if (matches = Objects.equals(entry.getValue(), val) || val.matches((String)entry.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    public static void removeCloudEventHeaders(CloudEvent ce, Message message) {
        for (CloudEvent.Attribute attr : ce.attributes()) {
            message.removeHeader(attr.http());
            message.removeHeader(attr.id());
        }
    }

    public static void remapCloudEventHeaders(CloudEvent ce, Message message) {
        for (CloudEvent.Attribute attr : ce.attributes()) {
            Object value = message.getHeader(attr.id());
            if (value == null) continue;
            message.setHeader(attr.http(), value);
        }
    }
}

