/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.http;

import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptionsBase;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.knative.http.TrustAllOptions;
import org.apache.camel.spi.PropertiesComponent;

public class KnativeSslClientOptions
extends WebClientOptions
implements CamelContextAware {
    private static final String PROPERTY_PREFIX = "camel.knative.client.ssl.";
    private CamelContext camelContext;
    private boolean sslEnabled;
    private boolean verifyHostName;
    private String keystorePath;
    private String keystorePassword;
    private String[] keyPath;
    private String[] keyCertPath;
    private String truststorePath;
    private String truststorePassword;
    private String[] trustCertPath;
    private KeyCertOptions keyCertOptions;
    private TrustOptions trustOptions;

    public KnativeSslClientOptions() {
    }

    public KnativeSslClientOptions(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.configureOptions(camelContext);
    }

    public void configureOptions() {
        if (this.camelContext != null) {
            this.configureOptions(this.camelContext);
        }
    }

    public void configureOptions(CamelContext camelContext) {
        PropertiesComponent propertiesComponent = camelContext.getPropertiesComponent();
        boolean sslEnabled = Boolean.parseBoolean(propertiesComponent.resolveProperty("camel.knative.client.ssl.enabled").orElse("false"));
        this.setSslEnabled(sslEnabled);
        if (sslEnabled) {
            boolean verifyHostname = Boolean.parseBoolean(propertiesComponent.resolveProperty("camel.knative.client.ssl.verify.hostname").orElse("true"));
            this.setVerifyHostName(verifyHostname);
            Optional keystorePath = propertiesComponent.resolveProperty("camel.knative.client.ssl.keystore.path");
            String keystorePassword = propertiesComponent.resolveProperty("camel.knative.client.ssl.keystore.password").orElse("");
            if (keystorePath.isPresent()) {
                this.setKeystorePath((String)keystorePath.get());
                this.setKeystorePassword(keystorePassword);
            } else {
                String[] keyCertPathItems;
                Optional keyCertPath;
                String[] keyPathItems;
                Optional keyPath = propertiesComponent.resolveProperty("camel.knative.client.ssl.key.path");
                if (keyPath.isPresent() && (keyPathItems = ((String)keyPath.get()).split(",")).length > 0) {
                    this.setKeyPath(keyPathItems);
                }
                if ((keyCertPath = propertiesComponent.resolveProperty("camel.knative.client.ssl.key.cert.path")).isPresent() && (keyCertPathItems = ((String)keyCertPath.get()).split(",")).length > 0) {
                    this.setKeyCertPath(keyCertPathItems);
                }
            }
            Optional truststorePath = propertiesComponent.resolveProperty("camel.knative.client.ssl.truststore.path");
            String truststorePassword = propertiesComponent.resolveProperty("camel.knative.client.ssl.truststore.password").orElse("");
            Optional trustCertPath = propertiesComponent.resolveProperty("camel.knative.client.ssl.trust.cert.path");
            if (truststorePath.isPresent()) {
                this.setTruststorePath((String)truststorePath.get());
                this.setTruststorePassword(truststorePassword);
            } else if (trustCertPath.isPresent()) {
                String[] trustCertPathItems = ((String)trustCertPath.get()).split(",");
                this.setTrustCertPath(trustCertPathItems);
            } else {
                this.trustOptions = TrustAllOptions.INSTANCE;
                this.setTrustOptions(this.trustOptions);
            }
        }
    }

    private void initializeKeyCertOptions(String path) {
        if (this.keyCertOptions == null) {
            this.keyCertOptions = path == null ? new JksOptions() : (path.endsWith(".p12") ? new PfxOptions() : (path.endsWith(".pem") ? new PemKeyCertOptions() : new JksOptions()));
            this.setKeyCertOptions(this.keyCertOptions);
        }
    }

    private void initializeTrustOptions(String path) {
        if (this.trustOptions == null) {
            this.trustOptions = path == null ? new JksOptions() : (path.endsWith(".p12") ? new PfxOptions() : (path.endsWith(".pem") ? new PemTrustOptions() : new JksOptions()));
            this.setTrustOptions(this.trustOptions);
        }
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        this.setSsl(sslEnabled);
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setVerifyHostName(boolean verifyHostName) {
        this.verifyHostName = verifyHostName;
        this.setVerifyHost(verifyHostName);
    }

    public boolean isVerifyHostName() {
        return this.verifyHostName;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
        this.initializeKeyCertOptions(keystorePath);
        KeyCertOptions keyCertOptions = this.keyCertOptions;
        if (keyCertOptions instanceof KeyStoreOptionsBase) {
            KeyStoreOptionsBase keyStoreOptionsBase = (KeyStoreOptionsBase)keyCertOptions;
            keyStoreOptionsBase.setPath(keystorePath);
        }
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        this.initializeKeyCertOptions(this.keystorePath);
        KeyCertOptions keyCertOptions = this.keyCertOptions;
        if (keyCertOptions instanceof KeyStoreOptionsBase) {
            KeyStoreOptionsBase keyStoreOptionsBase = (KeyStoreOptionsBase)keyCertOptions;
            keyStoreOptionsBase.setPassword(keystorePassword);
        }
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = new String[]{keyPath};
        this.initializeKeyCertOptions(keyPath);
        KeyCertOptions keyCertOptions = this.keyCertOptions;
        if (keyCertOptions instanceof PemKeyCertOptions) {
            PemKeyCertOptions pemKeyCertOptions = (PemKeyCertOptions)keyCertOptions;
            pemKeyCertOptions.setKeyPath(keyPath);
        }
    }

    public void setKeyPath(String ... keyPaths) {
        this.keyPath = keyPaths;
        this.initializeKeyCertOptions(keyPaths[0]);
        String[] stringArray = this.keyCertOptions;
        if (stringArray instanceof PemKeyCertOptions) {
            PemKeyCertOptions pemKeyCertOptions = (PemKeyCertOptions)stringArray;
            for (String path : keyPaths) {
                pemKeyCertOptions.addKeyPath(path.trim());
            }
        }
    }

    public String[] getKeyPath() {
        return this.keyPath;
    }

    public void setKeyCertPath(String keyCertPath) {
        this.keyCertPath = new String[]{keyCertPath};
        this.initializeKeyCertOptions(keyCertPath);
        KeyCertOptions keyCertOptions = this.keyCertOptions;
        if (keyCertOptions instanceof PemKeyCertOptions) {
            PemKeyCertOptions pemKeyCertOptions = (PemKeyCertOptions)keyCertOptions;
            pemKeyCertOptions.addCertPath(keyCertPath);
        }
    }

    public void setKeyCertPath(String ... keyCertPaths) {
        this.keyCertPath = keyCertPaths;
        this.initializeKeyCertOptions(keyCertPaths[0]);
        String[] stringArray = this.keyCertOptions;
        if (stringArray instanceof PemKeyCertOptions) {
            PemKeyCertOptions pemKeyCertOptions = (PemKeyCertOptions)stringArray;
            for (String certPath : keyCertPaths) {
                pemKeyCertOptions.addCertPath(certPath.trim());
            }
        }
    }

    public String[] getKeyCertPath() {
        return this.keyCertPath;
    }

    public void setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
        this.initializeTrustOptions(truststorePath);
        TrustOptions trustOptions = this.trustOptions;
        if (trustOptions instanceof KeyStoreOptionsBase) {
            KeyStoreOptionsBase keyStoreOptionsBase = (KeyStoreOptionsBase)trustOptions;
            keyStoreOptionsBase.setPath(truststorePath);
        }
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        this.initializeTrustOptions(this.truststorePath);
        TrustOptions trustOptions = this.trustOptions;
        if (trustOptions instanceof KeyStoreOptionsBase) {
            KeyStoreOptionsBase keyStoreOptionsBase = (KeyStoreOptionsBase)trustOptions;
            keyStoreOptionsBase.setPassword(truststorePassword);
        }
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTrustCertPath(String trustCertPath) {
        this.trustCertPath = new String[]{trustCertPath};
        this.initializeTrustOptions(trustCertPath);
        TrustOptions trustOptions = this.trustOptions;
        if (trustOptions instanceof PemTrustOptions) {
            PemTrustOptions pemTrustOptions = (PemTrustOptions)trustOptions;
            pemTrustOptions.addCertPath(trustCertPath);
        }
    }

    public void setTrustCertPath(String ... trustCertPaths) {
        this.trustCertPath = trustCertPaths;
        this.initializeTrustOptions(trustCertPaths[0]);
        String[] stringArray = this.trustOptions;
        if (stringArray instanceof PemTrustOptions) {
            PemTrustOptions pemTrustOptions = (PemTrustOptions)stringArray;
            for (String certPath : trustCertPaths) {
                pemTrustOptions.addCertPath(certPath.trim());
            }
        }
    }

    public String[] getTrustCertPath() {
        return this.trustCertPath;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.configureOptions();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

