/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.http;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Router;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvent;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.support.CamelContextHelper;

public final class KnativeHttpSupport {
    private static final String PLATFORM_HTTP_ROUTER_NAME = "platform-http-router";

    private KnativeHttpSupport() {
    }

    public static Predicate<HttpServerRequest> createFilter(CloudEvent cloudEvent, KnativeResource resource) {
        HashMap filters = new HashMap();
        for (Map.Entry entry : resource.getFilters().entrySet()) {
            cloudEvent.attribute((String)entry.getKey()).map(CloudEvent.Attribute::http).ifPresentOrElse(k -> filters.put(k, (String)entry.getValue()), () -> filters.put((String)entry.getKey(), (String)entry.getValue()));
        }
        return request -> {
            if (filters.isEmpty()) {
                return true;
            }
            for (Map.Entry entry : filters.entrySet()) {
                boolean matches;
                List values = request.headers().getAll((String)entry.getKey());
                if (values.isEmpty()) {
                    return false;
                }
                String val = (String)values.get(values.size() - 1);
                int idx = val.lastIndexOf(44);
                if (values.size() == 1 && idx != -1) {
                    val = val.substring(idx + 1);
                    val = val.trim();
                }
                if (matches = Objects.equals(entry.getValue(), val) || val.matches((String)entry.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    public static void removeCloudEventHeaders(CloudEvent ce, Message message) {
        for (CloudEvent.Attribute attr : ce.attributes()) {
            message.removeHeader(attr.http());
            message.removeHeader(attr.id());
        }
    }

    public static void remapCloudEventHeaders(CloudEvent ce, Message message) {
        for (CloudEvent.Attribute attr : ce.attributes()) {
            Object value = message.getHeader(attr.id());
            if (value == null) continue;
            message.setHeader(attr.http(), value);
        }
    }

    public static Router lookupRouter(CamelContext camelContext) {
        Router router = (Router)CamelContextHelper.findSingleByType((CamelContext)camelContext, Router.class);
        if (router != null) {
            return router;
        }
        router = (Router)CamelContextHelper.lookup((CamelContext)camelContext, (String)PLATFORM_HTTP_ROUTER_NAME, Router.class);
        if (router != null) {
            return router;
        }
        return Router.router((Vertx)KnativeHttpSupport.lookupVertxInstance(camelContext));
    }

    public static Vertx lookupVertxInstance(CamelContext camelContext) {
        Vertx vertx = (Vertx)CamelContextHelper.findSingleByType((CamelContext)camelContext, Vertx.class);
        if (vertx != null) {
            return vertx;
        }
        VertxOptions options = (VertxOptions)CamelContextHelper.findSingleByType((CamelContext)camelContext, VertxOptions.class);
        if (options == null) {
            options = new VertxOptions();
        }
        return Vertx.vertx((VertxOptions)options);
    }
}

