/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.http;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.client.impl.HttpContext;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.knative.http.KnativeOidcClientOptions;

public class KnativeOidcInterceptor
implements Handler<HttpContext<?>> {
    private final Set<HttpContext<?>> dejaVu = new HashSet();
    private final KnativeOidcClientOptions oidcClientOptions;

    public KnativeOidcInterceptor(KnativeOidcClientOptions options) {
        this.oidcClientOptions = options;
    }

    public void handle(HttpContext<?> context) {
        switch (context.phase()) {
            case CREATE_REQUEST: {
                this.addAuthorizationHeader(context);
                break;
            }
            case DISPATCH_RESPONSE: {
                this.checkTokenRenew(context);
                break;
            }
            default: {
                context.next();
            }
        }
    }

    private void checkTokenRenew(HttpContext<?> context) {
        if (context.response().statusCode() == 401) {
            if (!this.oidcClientOptions.isRenewTokenOnForbidden() || this.dejaVu.contains(context)) {
                this.dejaVu.remove(context);
                context.next();
            } else {
                this.dejaVu.add(context);
                String old = this.oidcClientOptions.retrieveOidcToken();
                String renewed = this.oidcClientOptions.renewOidcToken();
                if (old.equals(renewed)) {
                    this.dejaVu.remove(context);
                    context.next();
                } else {
                    context.createRequest(context.requestOptions());
                }
            }
        } else {
            this.dejaVu.remove(context);
            context.next();
        }
    }

    private void addAuthorizationHeader(HttpContext<?> context) {
        if (this.oidcClientOptions.getOidcTokenPath() == null) {
            context.fail((Throwable)new RuntimeCamelException("Missing OIDC access token path"));
            return;
        }
        context.requestOptions().putHeader(HttpHeaders.AUTHORIZATION, (CharSequence)("Bearer " + this.oidcClientOptions.retrieveOidcToken()));
        context.next();
    }
}

