/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.ce;

import java.io.InputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cloudevents.CloudEvent;
import org.apache.camel.component.knative.KnativeEndpoint;
import org.apache.camel.component.knative.ce.CloudEventProcessor;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCloudEventProcessor
implements CloudEventProcessor {
    private final CloudEvent cloudEvent;

    protected AbstractCloudEventProcessor(CloudEvent cloudEvent) {
        this.cloudEvent = cloudEvent;
    }

    @Override
    public CloudEvent cloudEvent() {
        return this.cloudEvent;
    }

    @Override
    public Processor consumer(KnativeEndpoint endpoint, KnativeResource service) {
        return exchange -> {
            if (Objects.equals(exchange.getIn().getHeader("Content-Type"), "application/cloudevents-batch+json")) {
                throw new UnsupportedOperationException("Batched CloudEvents are not yet supported");
            }
            if (!Objects.equals(exchange.getIn().getHeader("Content-Type"), "application/cloudevents+json")) {
                Map headers = exchange.getIn().getHeaders();
                for (CloudEvent.Attribute attribute : this.cloudEvent.attributes()) {
                    Object val = headers.remove(attribute.http());
                    if (val == null) continue;
                    headers.put(attribute.id(), val);
                }
            } else {
                try (InputStream is = (InputStream)exchange.getIn().getBody(InputStream.class);){
                    this.decodeStructuredContent(exchange, (Map)Knative.MAPPER.readValue(is, Map.class));
                }
            }
        };
    }

    protected abstract void decodeStructuredContent(Exchange var1, Map<String, Object> var2);

    @Override
    public Processor producer(KnativeEndpoint endpoint, KnativeResource service) {
        CloudEvent ce = this.cloudEvent();
        Logger logger = LoggerFactory.getLogger(this.getClass());
        String contentType = service.getContentType();
        return exchange -> {
            Map headers = exchange.getMessage().getHeaders();
            for (CloudEvent.Attribute attribute : ce.attributes()) {
                Object value = headers.get(attribute.id());
                if (value == null) continue;
                headers.putIfAbsent(attribute.http(), value);
            }
            if (contentType != null) {
                headers.putIfAbsent("Content-Type", contentType);
            }
            if (endpoint.getType() == Knative.Type.event && endpoint.getTypeId() != null) {
                Object eventType = headers.get("CamelCloudEventType");
                if (eventType != null) {
                    logger.debug("Detected the presence of {} header with value {}: it will be ignored and replaced by value set as uri parameter {}", new Object[]{"CamelCloudEventType", eventType, endpoint.getTypeId()});
                }
                headers.put(this.cloudEvent().mandatoryAttribute("CamelCloudEventType").http(), endpoint.getTypeId());
            } else {
                this.setCloudEventHeader(headers, "CamelCloudEventType", () -> {
                    String eventType = service.getCloudEventType();
                    if (eventType == null) {
                        eventType = endpoint.getConfiguration().getCloudEventsType();
                    }
                    return eventType;
                });
            }
            this.setCloudEventHeader(headers, "CamelCloudEventID", () -> ((Exchange)exchange).getExchangeId());
            this.setCloudEventHeader(headers, "CamelCloudEventSource", () -> ((Exchange)exchange).getFromRouteId());
            this.setCloudEventHeader(headers, "CamelCloudEventVersion", () -> ((CloudEvent)ce).version());
            this.setCloudEventHeader(headers, "CamelCloudEventTime", () -> {
                ZonedDateTime created = exchange.getClock().asZonedCreationDateTime();
                return DateTimeFormatter.ISO_INSTANT.format(created);
            });
            headers.putAll(service.getCeOverrides());
        };
    }

    protected void setCloudEventHeader(Map<String, Object> headers, String id, Supplier<Object> supplier) {
        headers.putIfAbsent(this.cloudEvent().mandatoryAttribute(id).http(), supplier.get());
    }
}

