/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.cloud.KubernetesServiceDiscovery;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDnsSrvServiceDiscovery
extends KubernetesServiceDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesDnsSrvServiceDiscovery.class);
    private static final String[] ATTRIBUTE_IDS = new String[]{"SRV"};
    private static final Hashtable<String, String> ENV = new Hashtable();
    private final String namespace;
    private final String portName;
    private final String portProtocol;
    private final String zone;
    private final Map<String, String> cache;

    public KubernetesDnsSrvServiceDiscovery(KubernetesConfiguration configuration) {
        super(configuration);
        this.namespace = configuration.getNamespace() != null ? configuration.getNamespace() : System.getenv("KUBERNETES_NAMESPACE");
        this.portName = configuration.getPortName();
        this.portProtocol = configuration.getPortProtocol();
        this.zone = configuration.getDnsDomain();
        ObjectHelper.notNull((Object)this.namespace, (String)"Namespace");
        ObjectHelper.notNull((Object)this.portName, (String)"Port Name");
        ObjectHelper.notNull((Object)this.portProtocol, (String)"Port Protocol");
        ObjectHelper.notNull((Object)this.zone, (String)"DNS Domain");
        this.cache = new HashMap<String, String>();
    }

    protected String computeQueryString(String serviceName) {
        return String.format("_%s._%s.%s.%s.svc.%s", this.portName, this.portProtocol, serviceName, this.namespace, this.zone);
    }

    public List<ServiceDefinition> getServices(String name) {
        try {
            String query = this.cache.computeIfAbsent(name, this::computeQueryString);
            InitialDirContext ctx = new InitialDirContext(ENV);
            NamingEnumeration<?> resolved = ctx.getAttributes(query, ATTRIBUTE_IDS).get("srv").getAll();
            if (resolved.hasMore()) {
                LinkedList<ServiceDefinition> servers = new LinkedList<ServiceDefinition>();
                while (resolved.hasMore()) {
                    String record = (String)resolved.next();
                    String[] items = record.split(" ", -1);
                    String host = items[3].trim();
                    String port = items[2].trim();
                    if (ObjectHelper.isEmpty((Object)host) || ObjectHelper.isEmpty((Object)port)) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Found service address {}:{} for query: {}", new Object[]{host, port, query});
                    }
                    if ("0".equals(port)) continue;
                    servers.add((ServiceDefinition)new DefaultServiceDefinition(name, host, Integer.parseInt(port)));
                }
                return servers;
            }
            LOGGER.warn("Could not find any service for name={}, query={}", (Object)name, (Object)query);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not resolve services via DNSSRV", e);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "KubernetesDnsSrvServiceDiscovery{namespace='" + this.namespace + '\'' + ", portName='" + this.portName + '\'' + ", portProtocol='" + this.portProtocol + '\'' + ", zone='" + this.zone + '\'' + '}';
    }

    static {
        ENV.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        ENV.put("java.naming.provider.url", "dns:");
    }
}

