/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.services;

import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.services.KubernetesServicesComponent;
import org.apache.camel.component.kubernetes.services.KubernetesServicesConsumer;
import org.apache.camel.component.kubernetes.services.KubernetesServicesProducer;
import org.apache.camel.spi.UriEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.17.0", scheme="kubernetes-services", title="Kubernetes Services", syntax="kubernetes-services:masterUrl", consumerClass=KubernetesServicesConsumer.class, label="container,cloud,paas")
public class KubernetesServicesEndpoint
extends AbstractKubernetesEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServicesEndpoint.class);

    public KubernetesServicesEndpoint(String uri, KubernetesServicesComponent component, KubernetesConfiguration config) {
        super(uri, component, config);
    }

    public Producer createProducer() throws Exception {
        return new KubernetesServicesProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new KubernetesServicesConsumer(this, processor);
    }
}

