/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.hpa;

import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesHPAProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHPAProducer.class);

    public KubernetesHPAProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listHPA": {
                this.doList(exchange);
                break;
            }
            case "listHPAByLabels": {
                this.doListHPAByLabel(exchange);
                break;
            }
            case "getHPA": {
                this.doGetHPA(exchange);
                break;
            }
            case "createHPA": {
                this.doCreateHPA(exchange);
                break;
            }
            case "deleteHPA": {
                this.doDeleteHPA(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        HorizontalPodAutoscalerList hpaList = (HorizontalPodAutoscalerList)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().list();
        KubernetesHelper.prepareOutboundMessage(exchange, hpaList.getItems());
    }

    protected void doListHPAByLabel(Exchange exchange) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesHPALabels", Map.class);
        if (ObjectHelper.isEmpty((Object)labels)) {
            LOG.error("Get HPA by labels require specify a labels set");
            throw new IllegalArgumentException("Get HPA by labels require specify a labels set");
        }
        HorizontalPodAutoscalerList hpaList = (HorizontalPodAutoscalerList)((FilterWatchListDeletable)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, hpaList.getItems());
    }

    protected void doGetHPA(Exchange exchange) {
        HorizontalPodAutoscaler hpa = null;
        String podName = (String)exchange.getIn().getHeader("CamelKubernetesHPAName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)podName)) {
            LOG.error("Get a specific hpa require specify an hpa name");
            throw new IllegalArgumentException("Get a specific hpa require specify an hpa name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific hpa require specify a namespace name");
            throw new IllegalArgumentException("Get a specific hpa require specify a namespace name");
        }
        hpa = (HorizontalPodAutoscaler)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().inNamespace(namespaceName)).withName(podName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, hpa);
    }

    protected void doCreateHPA(Exchange exchange) {
        HorizontalPodAutoscaler hpa = null;
        String hpaName = (String)exchange.getIn().getHeader("CamelKubernetesHPAName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        HorizontalPodAutoscalerSpec hpaSpec = (HorizontalPodAutoscalerSpec)exchange.getIn().getHeader("CamelKubernetesHPASpec", HorizontalPodAutoscalerSpec.class);
        if (ObjectHelper.isEmpty((Object)hpaName)) {
            LOG.error("Create a specific hpa require specify a hpa name");
            throw new IllegalArgumentException("Create a specific hpa require specify a hpa name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific hpa require specify a namespace name");
            throw new IllegalArgumentException("Create a specific hpa require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)hpaSpec)) {
            LOG.error("Create a specific hpa require specify a hpa spec bean");
            throw new IllegalArgumentException("Create a specific hpa require specify a hpa spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesHPALabels", Map.class);
        HorizontalPodAutoscaler hpaCreating = ((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.MetadataNested)((HorizontalPodAutoscalerFluent.MetadataNested)new HorizontalPodAutoscalerBuilder().withNewMetadata().withName(hpaName)).withLabels(labels)).endMetadata()).withSpec(hpaSpec)).build();
        hpa = (HorizontalPodAutoscaler)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().inNamespace(namespaceName)).create((Object)hpaCreating);
        KubernetesHelper.prepareOutboundMessage(exchange, hpa);
    }

    protected void doDeleteHPA(Exchange exchange) {
        String hpaName = (String)exchange.getIn().getHeader("CamelKubernetesHPAName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)hpaName)) {
            LOG.error("Delete a specific hpa require specify a hpa name");
            throw new IllegalArgumentException("Delete a specific hpa require specify a hpa name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific hpa require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific hpa require specify a namespace name");
        }
        boolean hpaDeleted = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers().inNamespace(namespaceName)).withName(hpaName)).delete();
        KubernetesHelper.prepareOutboundMessage(exchange, hpaDeleted);
    }
}

