/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.pods;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.kubernetes.consumer.common.PodEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPodsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPodsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private PodsConsumerTask podsWatcher;

    public KubernetesPodsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.podsWatcher = new PodsConsumerTask();
        this.executor.submit(this.podsWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Pods Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.podsWatcher, this.podsWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class PodsConsumerTask
    implements Runnable {
        private Watch watch;

        PodsConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation w = KubernetesPodsConsumer.this.getEndpoint().getKubernetesClient().pods();
            ObjectHelper.ifNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace(), arg_0 -> ((MixedOperation)w).inNamespace(arg_0));
            if (ObjectHelper.isNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), arg_0 -> ((MixedOperation)w).withName(arg_0));
            this.watch = w.watch((Object)new Watcher<Pod>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, Pod resource) {
                    PodEvent pe = new PodEvent(action, resource);
                    Exchange exchange = KubernetesPodsConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)pe.getPod());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)pe.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesPodsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesPodsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesPodsConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

