/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.resources_quota;

import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesResourcesQuotaProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesResourcesQuotaProducer.class);

    public KubernetesResourcesQuotaProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listResourcesQuota": {
                this.doList(exchange);
                break;
            }
            case "listSecretsByLabels": {
                this.doListResourceQuotasByLabels(exchange);
                break;
            }
            case "getResourceQuota": {
                this.doGetResourceQuota(exchange);
                break;
            }
            case "createResourceQuota": {
                this.doCreateResourceQuota(exchange);
                break;
            }
            case "deleteResourceQuota": {
                this.doDeleteResourceQuota(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        ResourceQuotaList resList = (ResourceQuotaList)((FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().resourceQuotas().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, resList.getItems());
    }

    protected void doListResourceQuotasByLabels(Exchange exchange) {
        ResourceQuotaList resList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            NonNamespaceOperation resQuota = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                resQuota.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            resList = (ResourceQuotaList)resQuota.list();
        } else {
            MixedOperation resQuota = this.getEndpoint().getKubernetesClient().resourceQuotas();
            for (Map.Entry entry : labels.entrySet()) {
                resQuota.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            resList = (ResourceQuotaList)resQuota.list();
        }
        KubernetesHelper.prepareOutboundMessage(exchange, resList.getItems());
    }

    protected void doGetResourceQuota(Exchange exchange) {
        ResourceQuota rq = null;
        String rqName = (String)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rqName)) {
            LOG.error("Get a specific Resource Quota require specify a Resource Quota name");
            throw new IllegalArgumentException("Get a specific Resource Quota require specify a Resource Quota name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Resource Quota require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Resource Quota require specify a namespace name");
        }
        rq = (ResourceQuota)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName)).withName(rqName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, rq);
    }

    protected void doCreateResourceQuota(Exchange exchange) {
        ResourceQuota rq = null;
        String rqName = (String)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ResourceQuotaSpec rqSpec = (ResourceQuotaSpec)exchange.getIn().getHeader("CamelKubernetesResourceQuotaSpec", ResourceQuotaSpec.class);
        if (ObjectHelper.isEmpty((Object)rqName)) {
            LOG.error("Create a specific resource quota require specify a resource quota name");
            throw new IllegalArgumentException("Create a specific resource quota require specify a resource quota name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific resource quota require specify a namespace name");
            throw new IllegalArgumentException("Create a specific resource quota require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)rqSpec)) {
            LOG.error("Create a specific resource quota require specify a resource quota spec bean");
            throw new IllegalArgumentException("Create a specific resource quota require specify a resource quota spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaLabels", Map.class);
        ResourceQuota rqCreating = ((ResourceQuotaBuilder)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName(rqName)).withLabels(labels)).endMetadata()).withSpec(rqSpec)).build();
        rq = (ResourceQuota)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName)).create((Object)rqCreating);
        KubernetesHelper.prepareOutboundMessage(exchange, rq);
    }

    protected void doDeleteResourceQuota(Exchange exchange) {
        String rqName = (String)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rqName)) {
            LOG.error("Delete a specific resource quota require specify a resource quota name");
            throw new IllegalArgumentException("Delete a specific resource quota require specify a resource quota name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific resource quota require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific resource quota require specify a namespace name");
        }
        boolean rqDeleted = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName)).withName(rqName)).delete();
        KubernetesHelper.prepareOutboundMessage(exchange, rqDeleted);
    }
}

