/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.services;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.kubernetes.consumer.common.ServiceEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServicesConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServicesConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private ServicesConsumerTask servicesWatcher;

    public KubernetesServicesConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.servicesWatcher = new ServicesConsumerTask();
        this.executor.submit(this.servicesWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Services Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.servicesWatcher, this.servicesWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ServicesConsumerTask
    implements Runnable {
        private Watch watch;

        ServicesConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation w = KubernetesServicesConsumer.this.getEndpoint().getKubernetesClient().services();
            ObjectHelper.ifNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace(), arg_0 -> ((MixedOperation)w).inNamespace(arg_0));
            if (ObjectHelper.isNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), arg_0 -> ((MixedOperation)w).withName(arg_0));
            this.watch = w.watch((Object)new Watcher<Service>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, Service resource) {
                    ServiceEvent se = new ServiceEvent(action, resource);
                    Exchange exchange = KubernetesServicesConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)se.getService());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)se.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesServicesConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesServicesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesServicesConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

