/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.replication_controllers;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesReplicationControllersConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesReplicationControllersConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private ReplicationControllersConsumerTask rcWatcher;

    public KubernetesReplicationControllersConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.rcWatcher = new ReplicationControllersConsumerTask();
        this.executor.submit(this.rcWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Replication Controllers Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.rcWatcher, this.rcWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ReplicationControllersConsumerTask
    implements Runnable {
        private Watch watch;

        ReplicationControllersConsumerTask() {
        }

        @Override
        public void run() {
            FilterWatchListDeletable w;
            String namespace = KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace();
            String labelKey = KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey();
            String labelValue = KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue();
            String resourceName = KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName();
            if (ObjectHelper.isEmpty((String)namespace)) {
                w = (FilterWatchListDeletable)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesClient().replicationControllers().inAnyNamespace();
                if (ObjectHelper.isNotEmpty((String)labelKey) && ObjectHelper.isNotEmpty((String)labelValue)) {
                    w = (FilterWatchListDeletable)w.withLabel(labelKey, labelValue);
                }
            } else {
                NonNamespaceOperation client = (NonNamespaceOperation)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespace);
                w = client;
                if (ObjectHelper.isNotEmpty((String)labelKey) && ObjectHelper.isNotEmpty((String)labelValue)) {
                    w = (FilterWatchListDeletable)client.withLabel(labelKey, labelValue);
                } else if (ObjectHelper.isNotEmpty((String)resourceName)) {
                    w = (FilterWatchListDeletable)client.withName(resourceName);
                }
            }
            this.watch = w.watch((Watcher)new Watcher<ReplicationController>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, ReplicationController resource) {
                    Exchange exchange = KubernetesReplicationControllersConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesReplicationControllersConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesReplicationControllersConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesReplicationControllersConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

