/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain.embeddings;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.langchain.embeddings.LangChainEmbeddings;
import org.apache.camel.component.langchain.embeddings.LangChainEmbeddingsConfiguration;
import org.apache.camel.component.langchain.embeddings.LangChainEmbeddingsProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.5.0", scheme="langchain-embeddings", title="LangChain4j Embeddings", syntax="langchain4j-embeddings:embeddingId", producerOnly=true, category={Category.AI}, headersClass=LangChainEmbeddings.Headers.class)
public class LangChainEmbeddingsEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The id")
    private final String embeddingId;
    @UriParam
    private LangChainEmbeddingsConfiguration configuration;

    public LangChainEmbeddingsEndpoint(String endpointUri, Component component, String embeddingId, LangChainEmbeddingsConfiguration configuration) {
        super(endpointUri, component);
        this.embeddingId = embeddingId;
        this.configuration = configuration;
    }

    public LangChainEmbeddingsConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getEmbeddingId() {
        return this.embeddingId;
    }

    public Producer createProducer() throws Exception {
        return new LangChainEmbeddingsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }
}

