/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.chat.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.component.langchain4j.chat.tool.CamelToolSpecification;

public final class CamelToolExecutorCache {
    private static CamelToolExecutorCache INSTANCE;
    private Map<String, List<CamelToolSpecification>> tools = new ConcurrentHashMap<String, List<CamelToolSpecification>>();

    private CamelToolExecutorCache() {
    }

    public static synchronized CamelToolExecutorCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CamelToolExecutorCache();
        }
        return INSTANCE;
    }

    public void put(String chatId, CamelToolSpecification specification) {
        if (this.tools.get(chatId) != null) {
            this.tools.get(chatId).add(specification);
        } else {
            ArrayList<CamelToolSpecification> camelToolSpecifications = new ArrayList<CamelToolSpecification>();
            camelToolSpecifications.add(specification);
            this.tools.put(chatId, camelToolSpecifications);
        }
    }

    public Map<String, List<CamelToolSpecification>> getTools() {
        return this.tools;
    }
}

