/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.embeddings;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.langchain4j.embeddings.LangChain4jEmbeddingsEndpoint;
import org.apache.camel.support.DefaultProducer;

public class LangChain4jEmbeddingsProducer
extends DefaultProducer {
    public LangChain4jEmbeddingsProducer(LangChain4jEmbeddingsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public LangChain4jEmbeddingsEndpoint getEndpoint() {
        return (LangChain4jEmbeddingsEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        TextSegment in = (TextSegment)exchange.getMessage().getMandatoryBody(TextSegment.class);
        EmbeddingModel model = this.getEndpoint().getConfiguration().getEmbeddingModel();
        Response result = model.embed(in);
        Message message = exchange.getMessage();
        if (result.finishReason() != null) {
            message.setHeader("CamelLangChain4jEmbeddingsFinishReason", (Object)result.finishReason());
        }
        if (result.tokenUsage() != null) {
            message.setHeader("CamelLangChain4jEmbeddingsInputTokenCount", (Object)result.tokenUsage().inputTokenCount());
            message.setHeader("CamelLangChain4jEmbeddingsOutputTokenCount", (Object)result.tokenUsage().outputTokenCount());
            message.setHeader("CamelLangChain4jEmbeddingsTotalTokenCount", (Object)result.tokenUsage().totalTokenCount());
        }
        message.setHeader("CamelLangChain4jEmbeddingsVector", (Object)((Embedding)result.content()).vector());
    }
}

