/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.langchain4j.tools.LangChain4jToolsEndpoint;
import org.apache.camel.component.langchain4j.tools.TagsHelper;
import org.apache.camel.component.langchain4j.tools.spec.CamelToolExecutorCache;
import org.apache.camel.component.langchain4j.tools.spec.CamelToolSpecification;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class LangChain4jToolsProducer
extends DefaultProducer {
    private final LangChain4jToolsEndpoint endpoint;
    private ChatLanguageModel chatLanguageModel;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public LangChain4jToolsProducer(LangChain4jToolsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        this.processMultipleMessages(exchange);
    }

    private void processMultipleMessages(Exchange exchange) throws InvalidPayloadException {
        List messages = (List)exchange.getIn().getMandatoryBody(List.class);
        this.populateResponse(this.toolsChat(messages, exchange), exchange);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.chatLanguageModel = this.endpoint.getConfiguration().getChatModel();
        ObjectHelper.notNull((Object)this.chatLanguageModel, (String)"chatLanguageModel");
    }

    private void populateResponse(String response, Exchange exchange) {
        exchange.getMessage().setBody((Object)response);
    }

    private boolean isMatch(String[] tags, Map.Entry<String, Set<CamelToolSpecification>> entry) {
        for (String tag : tags) {
            if (!entry.getKey().equals(tag)) continue;
            return true;
        }
        return false;
    }

    private String toolsChat(List<ChatMessage> chatMessages, Exchange exchange) {
        CamelToolExecutorCache toolCache = CamelToolExecutorCache.getInstance();
        ToolPair toolPair = this.computeCandidates(toolCache);
        Response<AiMessage> response = this.chatWithLLMForTools(chatMessages, toolPair);
        return this.chatWithLLMForToolCalling(chatMessages, exchange, response, toolPair);
    }

    private String chatWithLLMForToolCalling(List<ChatMessage> chatMessages, Exchange exchange, Response<AiMessage> response, ToolPair toolPair) {
        for (ToolExecutionRequest toolExecutionRequest : ((AiMessage)response.content()).toolExecutionRequests()) {
            String toolName = toolExecutionRequest.name();
            CamelToolSpecification camelToolSpecification = toolPair.callableTools().stream().filter(c -> c.getToolSpecification().name().equals(toolName)).findFirst().get();
            try {
                JsonNode jsonNode = (JsonNode)this.objectMapper.readValue(toolExecutionRequest.arguments(), JsonNode.class);
                jsonNode.fieldNames().forEachRemaining(name -> exchange.getMessage().setHeader(name, (Object)jsonNode.get(name)));
                camelToolSpecification.getConsumer().getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            chatMessages.add((ChatMessage)new ToolExecutionResultMessage(toolExecutionRequest.id(), toolExecutionRequest.name(), (String)exchange.getIn().getBody(String.class)));
        }
        Response generate = this.chatLanguageModel.generate(chatMessages);
        return this.extractAiResponse((Response<AiMessage>)generate);
    }

    private Response<AiMessage> chatWithLLMForTools(List<ChatMessage> chatMessages, ToolPair toolPair) {
        Response response = this.chatLanguageModel.generate(chatMessages, toolPair.toolSpecifications());
        if (!((AiMessage)response.content()).hasToolExecutionRequests()) {
            throw new RuntimeCamelException("There are no tools to be executed");
        }
        chatMessages.add((ChatMessage)response.content());
        return response;
    }

    private ToolPair computeCandidates(CamelToolExecutorCache toolCache) {
        ArrayList<ToolSpecification> toolSpecifications = new ArrayList<ToolSpecification>();
        ArrayList<CamelToolSpecification> callableTools = new ArrayList<CamelToolSpecification>();
        Map<String, Set<CamelToolSpecification>> tools = toolCache.getTools();
        String[] tags = TagsHelper.splitTags(this.endpoint.getTags());
        for (Map.Entry<String, Set<CamelToolSpecification>> entry : tools.entrySet()) {
            if (!this.isMatch(tags, entry)) continue;
            List callablesForTag = entry.getValue().stream().toList();
            callableTools.addAll(callablesForTag);
            List<ToolSpecification> toolsForTag = entry.getValue().stream().map(CamelToolSpecification::getToolSpecification).toList();
            toolSpecifications.addAll(toolsForTag);
        }
        if (toolSpecifications.isEmpty()) {
            throw new RuntimeCamelException("No tools matching the tags provided by the producer were found");
        }
        return new ToolPair(toolSpecifications, callableTools);
    }

    private String extractAiResponse(Response<AiMessage> response) {
        AiMessage message = (AiMessage)response.content();
        return message == null ? null : message.text();
    }

    private record ToolPair(List<ToolSpecification> toolSpecifications, List<CamelToolSpecification> callableTools) {
    }
}

