/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb.serializer;

import java.io.IOException;
import java.io.Serializable;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.component.leveldb.LevelDBSerializer;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;

public abstract class AbstractLevelDBSerializer
implements LevelDBSerializer {
    protected byte[] serializeExchange(CamelContext camelContext, Exchange exchange, boolean allowSerializedHeaders, Serializer serializer) throws IOException {
        DefaultExchangeHolder pe = this.createExchangeHolder(exchange, allowSerializedHeaders);
        return serializer.serialize(pe);
    }

    protected Exchange deserializeExchange(CamelContext camelContext, byte[] buffer, Deserializer deserializer) throws IOException {
        DefaultExchangeHolder pe = deserializer.deserialize(buffer);
        DefaultExchange answer = new DefaultExchange(camelContext);
        DefaultExchangeHolder.unmarshal((Exchange)answer, (DefaultExchangeHolder)pe);
        return answer;
    }

    DefaultExchangeHolder createExchangeHolder(Exchange exchange, boolean allowSerializedHeaders) {
        DefaultExchangeHolder pe = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)false, (boolean)allowSerializedHeaders);
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedSize", (Serializable)((Serializable)exchange.getProperty(ExchangePropertyKey.AGGREGATED_SIZE, Integer.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedTimeout", (Serializable)((Serializable)exchange.getProperty(ExchangePropertyKey.AGGREGATED_TIMEOUT, Long.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCompletedBy", (Serializable)((Serializable)exchange.getProperty(ExchangePropertyKey.AGGREGATED_COMPLETED_BY, String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCorrelationKey", (Serializable)((Serializable)exchange.getProperty(ExchangePropertyKey.AGGREGATED_CORRELATION_KEY, String.class)));
        DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedCollectionGuard", (Serializable)((Serializable)exchange.getProperty("CamelAggregatedCollectionGuard", String.class)));
        if (exchange.getFromEndpoint() != null) {
            DefaultExchangeHolder.addProperty((DefaultExchangeHolder)pe, (String)"CamelAggregatedFromEndpoint", (Serializable)((Object)exchange.getFromEndpoint().getEndpointUri()));
        }
        return pe;
    }

    @FunctionalInterface
    protected static interface Serializer {
        public byte[] serialize(DefaultExchangeHolder var1) throws IOException;
    }

    @FunctionalInterface
    protected static interface Deserializer {
        public DefaultExchangeHolder deserialize(byte[] var1) throws IOException;
    }
}

