/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb.serializer;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.leveldb.serializer.AbstractLevelDBSerializer;
import org.apache.camel.component.leveldb.serializer.jackson.ObjectMapperHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;

public class JacksonLevelDBSerializer
extends AbstractLevelDBSerializer {
    private final ObjectMapper objectMapper;

    public JacksonLevelDBSerializer() {
        this(null);
    }

    public JacksonLevelDBSerializer(Module customMudule) {
        this.objectMapper = ObjectMapperHelper.create(customMudule);
    }

    @Override
    public byte[] serializeKey(String key) throws IOException {
        return this.objectMapper.writeValueAsBytes((Object)key);
    }

    @Override
    public String deserializeKey(byte[] buffer) throws IOException {
        return (String)this.objectMapper.readValue(buffer, String.class);
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] serializeExchange(CamelContext camelContext, Exchange exchange, boolean allowSerializedHeaders) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Exchange deserializeExchange(CamelContext camelContext, byte[] buffer) throws IOException {
        DefaultExchangeHolder pe;
        Object outBody;
        Object inBody;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
             DataInputStream dis = new DataInputStream(bis);){
            inBody = this.deserializeByteArrayBody(dis);
            outBody = this.deserializeByteArrayBody(dis);
            pe = (DefaultExchangeHolder)this.objectMapper.readValue((InputStream)bis, DefaultExchangeHolder.class);
        }
        DefaultExchange answer = new DefaultExchange(camelContext);
        DefaultExchangeHolder.unmarshal((Exchange)answer, (DefaultExchangeHolder)pe);
        if (inBody != null) {
            answer.getIn().setBody(inBody);
        }
        if (outBody != null) {
            answer.getMessage().setBody(outBody);
        }
        return answer;
    }

    private void serializeByteArrayBody(Object body, DataOutputStream dos) throws IOException {
        if (body instanceof byte[]) {
            int length = ((byte[])body).length;
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(length);
            dos.write(bb.array());
            dos.write((byte[])body);
        } else {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(0);
            dos.write(bb.array());
        }
    }

    private Object deserializeByteArrayBody(DataInputStream dis) throws IOException {
        byte[] b = new byte[4];
        dis.read(b);
        int length = ByteBuffer.wrap(b).getInt();
        byte[] payload = null;
        if (length > 0) {
            payload = new byte[length];
            dis.read(payload);
        }
        return payload;
    }
}

