/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.leveldb.serializer.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.apache.camel.component.leveldb.serializer.jackson.HolderBodyMixin;
import org.apache.camel.support.DefaultExchangeHolder;

public final class ObjectMapperHelper {
    private ObjectMapperHelper() {
    }

    public static ObjectMapper create(Module customModule) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.setMixInAnnotation(DefaultExchangeHolder.class, HolderBodyMixin.class);
        objectMapper.registerModule((Module)simpleModule);
        if (customModule != null) {
            objectMapper.registerModule(customModule);
        }
        return objectMapper;
    }
}

