/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.service.lra.LRASagaService;
import org.apache.camel.util.URISupport;

public class LRASagaRoutes
extends RouteBuilder {
    private LRASagaService sagaService;

    public LRASagaRoutes(LRASagaService sagaService) {
        this.sagaService = sagaService;
    }

    public void configure() throws Exception {
        ((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.rest(this.sagaService.getLocalParticipantContextPath()).put("/compensate").route().id("lra-compensation")).process(this::verifyRequest)).choice().when(this.header("Camel-Saga-Compensate").isNotNull()).toD("${header.Camel-Saga-Compensate}")).end();
        ((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.rest(this.sagaService.getLocalParticipantContextPath()).put("/complete").route().id("lra-completion")).process(this::verifyRequest)).choice().when(this.header("Camel-Saga-Complete").isNotNull()).toD("${header.Camel-Saga-Complete}")).end();
    }

    private void verifyRequest(Exchange exchange) {
        String completionURI;
        if (exchange.getIn().getHeader("Long-Running-Action") == null) {
            throw new IllegalArgumentException("Missing Long-Running-Action header in received request");
        }
        HashSet<String> usedURIs = new HashSet<String>();
        String compensationURI = (String)exchange.getIn().getHeader("Camel-Saga-Compensate", String.class);
        if (compensationURI != null) {
            usedURIs.add(compensationURI);
        }
        if ((completionURI = (String)exchange.getIn().getHeader("Camel-Saga-Complete", String.class)) != null) {
            usedURIs.add(completionURI);
        }
        if (usedURIs.isEmpty()) {
            try {
                Map queryParams = URISupport.parseQuery((String)((String)exchange.getIn().getHeader("CamelHttpQuery", String.class)));
                if (!queryParams.isEmpty()) {
                    if (queryParams.get("Camel-Saga-Compensate") != null) {
                        compensationURI = queryParams.get("Camel-Saga-Compensate").toString();
                        usedURIs.add(compensationURI);
                        exchange.getIn().setHeader("Camel-Saga-Compensate", (Object)compensationURI);
                    }
                    if (queryParams.get("Camel-Saga-Complete") != null) {
                        completionURI = queryParams.get("Camel-Saga-Complete").toString();
                        usedURIs.add(completionURI);
                        exchange.getIn().setHeader("Camel-Saga-Complete", (Object)completionURI);
                    }
                }
            }
            catch (URISyntaxException ex) {
                throw new RuntimeCamelException("URISyntaxException during CamelHttpQuery header parsing");
            }
        }
        for (String uri : usedURIs) {
            if (this.sagaService.getRegisteredURIs().contains(uri)) continue;
            throw new IllegalArgumentException("URI " + uri + " is not allowed");
        }
    }
}

