/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.service.lra.LRASagaService;
import org.apache.camel.service.lra.LRASagaStep;
import org.apache.camel.service.lra.LRAUrlBuilder;
import org.apache.camel.util.ObjectHelper;

public class LRAClient
implements Closeable {
    private final LRASagaService sagaService;
    private final HttpClient client;
    private final String lraUrl;

    public LRAClient(LRASagaService sagaService) {
        this.sagaService = sagaService;
        this.client = HttpClient.newHttpClient();
        this.lraUrl = new LRAUrlBuilder().host(sagaService.getCoordinatorUrl()).path(sagaService.getCoordinatorContextPath()).build();
    }

    public CompletableFuture<URL> newLRA() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.lraUrl + "/start")).POST(HttpRequest.BodyPublishers.ofString("")).build();
        CompletableFuture<HttpResponse<String>> future = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        return future.thenApply(res -> {
            List<String> location = res.headers().map().get("Location");
            if (ObjectHelper.isNotEmpty(location)) {
                return this.toURL(location.get(0));
            }
            List<String> lraHeaders = res.headers().map().get("Long-Running-Action");
            if (ObjectHelper.isNotEmpty(lraHeaders) && lraHeaders.size() == 1) {
                return this.toURL(lraHeaders.get(0));
            }
            String responseBody = (String)res.body();
            if (ObjectHelper.isNotEmpty((String)responseBody)) {
                return this.toURL(responseBody);
            }
            throw new IllegalStateException("Cannot obtain LRA id from LRA coordinator");
        });
    }

    public CompletableFuture<Void> join(URL lra, LRASagaStep step) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            LRAUrlBuilder participantBaseUrl = new LRAUrlBuilder().host(this.sagaService.getLocalParticipantUrl()).path(this.sagaService.getLocalParticipantContextPath()).options(step.getOptions()).compensation(step.getCompensation()).completion(step.getCompletion());
            String compensationURL = participantBaseUrl.path("/compensate").build();
            String completionURL = participantBaseUrl.path("/complete").build();
            StringBuilder link = new StringBuilder();
            link.append('<').append(compensationURL).append('>').append("; rel=compensate");
            link.append(',');
            link.append('<').append(completionURL).append('>').append("; rel=complete");
            Object lraEndpoint = lra.toString();
            if (step.getTimeoutInMilliseconds().isPresent()) {
                lraEndpoint = (String)lraEndpoint + "?TimeLimit=" + step.getTimeoutInMilliseconds().get();
            }
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create((String)lraEndpoint)).header("Link", link.toString()).header("Long-Running-Action", lra.toString()).header("Content-Type", "text/plain").PUT(HttpRequest.BodyPublishers.ofString(link.toString())).build();
            return this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        }, this.sagaService.getExecutorService()).thenCompose(Function.identity())).thenApply(response -> {
            if (response.statusCode() != 200) {
                throw new RuntimeCamelException("Cannot join LRA");
            }
            return null;
        });
    }

    public CompletableFuture<Void> complete(URL lra) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(lra.toString() + "/close")).header("Content-Type", "text/plain").PUT(HttpRequest.BodyPublishers.ofString("")).build();
        CompletableFuture<HttpResponse<String>> future = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        return future.thenApply(response -> {
            if (response.statusCode() != 200) {
                throw new RuntimeCamelException("Cannot complete LRA");
            }
            return null;
        });
    }

    public CompletableFuture<Void> compensate(URL lra) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(lra.toString() + "/cancel")).header("Content-Type", "text/plain").PUT(HttpRequest.BodyPublishers.ofString("")).build();
        CompletableFuture<HttpResponse<String>> future = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        return future.thenApply(response -> {
            if (response.statusCode() != 200) {
                throw new RuntimeCamelException("Cannot compensate LRA");
            }
            return null;
        });
    }

    private URL toURL(Object url) {
        if (url == null) {
            return null;
        }
        if (url instanceof URL) {
            return (URL)URL.class.cast(url);
        }
        try {
            return new URL(url.toString());
        }
        catch (Exception ex) {
            throw new RuntimeCamelException((Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

