/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.lucene.LuceneConfiguration;
import org.apache.camel.component.lucene.LuceneEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;

public class LuceneComponent
extends UriEndpointComponent {
    @Metadata(label="advanced")
    private LuceneConfiguration config = new LuceneConfiguration();

    public LuceneComponent() {
        super(LuceneEndpoint.class);
    }

    public LuceneComponent(CamelContext context) {
        super(context, LuceneEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.config.parseURI(new URI(uri), parameters, this);
        LuceneEndpoint luceneEndpoint = new LuceneEndpoint(uri, this, this.config);
        this.setProperties(luceneEndpoint.getConfig(), parameters);
        return luceneEndpoint;
    }

    public LuceneConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(LuceneConfiguration config) {
        this.config = config;
    }
}

