/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.util.IOHelper;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndexer.class);
    private static final FieldType TOKENIZED_FIELD_TYPE = LuceneIndexer.createFieldType(true);
    private static final FieldType NON_TOKENIZED_FIELD_TYPE = LuceneIndexer.createFieldType(false);
    private File sourceDirectory;
    private Analyzer analyzer;
    private NIOFSDirectory niofsDirectory;
    private IndexWriter indexWriter;
    private boolean sourceDirectoryIndexed;

    public LuceneIndexer(File sourceDirectory, File indexDirectory, Analyzer analyzer) throws Exception {
        if (indexDirectory != null) {
            if (!indexDirectory.exists()) {
                indexDirectory.mkdir();
            }
            this.setNiofsDirectory(new NIOFSDirectory(indexDirectory.toPath()));
        } else {
            this.setNiofsDirectory(new NIOFSDirectory(new File("./indexDirectory").toPath()));
        }
        this.setAnalyzer(analyzer);
        if (sourceDirectory != null && !this.sourceDirectoryIndexed) {
            this.setSourceDirectory(sourceDirectory);
            this.add(this.getSourceDirectory());
            this.sourceDirectoryIndexed = true;
        }
    }

    public void index(Exchange exchange) throws Exception {
        LOG.debug("Indexing {}", (Object)exchange);
        this.openIndexWriter();
        Map headers = exchange.getIn().getHeaders();
        this.add("exchangeId", exchange.getExchangeId(), true);
        for (Map.Entry entry : headers.entrySet()) {
            String field = (String)entry.getKey();
            String value = (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, entry.getValue());
            this.add(field, value, true);
        }
        this.add("contents", (String)exchange.getIn().getMandatoryBody(String.class), true);
        this.closeIndexWriter();
    }

    public NIOFSDirectory getNiofsDirectory() {
        return this.niofsDirectory;
    }

    public void setNiofsDirectory(NIOFSDirectory niofsDirectory) {
        this.niofsDirectory = niofsDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    private void add(String field, String value, boolean analyzed) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding field: {}", (Object)field);
            LOG.trace("       value: {}", (Object)value);
        }
        Document doc = new Document();
        doc.add((IndexableField)new Field(field, (CharSequence)value, (IndexableFieldType)(analyzed ? TOKENIZED_FIELD_TYPE : NON_TOKENIZED_FIELD_TYPE)));
        this.indexWriter.addDocument((Iterable)doc);
    }

    private void add(File file) throws IOException {
        if (file.canRead()) {
            if (file.isDirectory()) {
                String[] files = file.list();
                if (files != null) {
                    for (String child : files) {
                        this.add(new File(file.getAbsolutePath() + "/" + child));
                    }
                }
            } else {
                String contents;
                LOG.trace("Adding {}", (Object)file);
                try (FileInputStream is = new FileInputStream(file);){
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    IOHelper.copy((InputStream)IOHelper.buffered((InputStream)is), (OutputStream)bos);
                    contents = bos.toString();
                }
                this.openIndexWriter();
                this.add("path", file.getPath(), false);
                this.add("contents", contents, true);
                this.closeIndexWriter();
                LOG.trace("Added {} successfully", (Object)file);
            }
        } else {
            LOG.warn("Directory/File {} could not be read. This directory will not be indexed. Please check permissions and rebuild indexes.", (Object)file.getAbsolutePath());
        }
    }

    private void openIndexWriter() throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        this.indexWriter = new IndexWriter((Directory)this.niofsDirectory, indexWriterConfig);
    }

    private void closeIndexWriter() throws IOException {
        this.indexWriter.commit();
        this.indexWriter.close();
    }

    private static FieldType createFieldType(boolean tokenized) {
        FieldType answer = new FieldType();
        answer.setStored(true);
        answer.setTokenized(tokenized);
        answer.freeze();
        return answer;
    }
}

