/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack;

import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.lumberjack.LumberjackEndpoint;
import org.apache.camel.component.lumberjack.io.LumberjackMessageProcessor;
import org.apache.camel.component.lumberjack.io.LumberjackServer;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.concurrent.CamelThreadFactory;

public class LumberjackConsumer
extends DefaultConsumer {
    private final LumberjackServer lumberjackServer;

    public LumberjackConsumer(LumberjackEndpoint endpoint, Processor processor, String host, int port, SSLContext sslContext) {
        super((Endpoint)endpoint, processor);
        this.lumberjackServer = new LumberjackServer(host, port, sslContext, this.getThreadFactory(), this::onMessageReceived);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.lumberjackServer.start();
    }

    protected void doStop() throws Exception {
        this.lumberjackServer.stop();
        super.doStop();
    }

    protected void doResume() throws Exception {
        super.doResume();
        this.lumberjackServer.start();
    }

    protected void doSuspend() throws Exception {
        this.lumberjackServer.stop();
        super.doSuspend();
    }

    private ThreadFactory getThreadFactory() {
        String threadNamePattern = this.getEndpoint().getCamelContext().getExecutorServiceManager().getThreadNamePattern();
        return new CamelThreadFactory(threadNamePattern, "LumberjackNettyExecutor", true);
    }

    private void onMessageReceived(Object payload, LumberjackMessageProcessor.Callback callback) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody(payload);
        this.getAsyncProcessor().process(exchange, doneSync -> callback.onComplete(!exchange.isFailed()));
    }
}

