/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack.io;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.apache.camel.component.lumberjack.io.LumberjackChannelInitializer;
import org.apache.camel.component.lumberjack.io.LumberjackMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LumberjackServer {
    private static final Logger LOG = LoggerFactory.getLogger(LumberjackServer.class);
    private static final int WORKER_THREADS = 16;
    private final String host;
    private final int port;
    private final SSLContext sslContext;
    private final ThreadFactory threadFactory;
    private final LumberjackMessageProcessor messageProcessor;
    private EventExecutorGroup executorService;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public LumberjackServer(String host, int port, SSLContext sslContext, ThreadFactory threadFactory, LumberjackMessageProcessor messageProcessor) {
        this.host = host;
        this.port = port;
        this.sslContext = sslContext;
        this.threadFactory = threadFactory;
        this.messageProcessor = messageProcessor;
    }

    public void start() throws InterruptedException {
        LOG.info("Starting the LUMBERJACK server (host={}, port={}).", (Object)this.host, (Object)this.port);
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(16);
        this.executorService = new DefaultEventExecutorGroup(16, this.threadFactory);
        LumberjackChannelInitializer initializer = new LumberjackChannelInitializer(this.sslContext, this.executorService, this.messageProcessor);
        ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).childHandler((ChannelHandler)initializer);
        this.channel = serverBootstrap.bind(this.host, this.port).sync().channel();
        LOG.info("LUMBERJACK server is started (host={}, port={}).", (Object)this.host, (Object)this.port);
    }

    public void stop() throws InterruptedException {
        LOG.info("Stopping the LUMBERJACK server (host={}, port={}).", (Object)this.host, (Object)this.port);
        try {
            this.channel.close().sync();
        }
        finally {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            this.executorService.shutdownGracefully();
        }
        LOG.info("LUMBERJACK server is stopped (host={}, port={}).", (Object)this.host, (Object)this.port);
    }
}

