/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MailEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port";
    private static final String[] SCHEMES = new String[]{"imap", "imaps", "pop3", "pop3s", "smtp", "smtps"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(68);
        props.add("disconnect");
        props.add("contentTypeResolver");
        props.add("subject");
        props.add("binding");
        props.add("initialDelay");
        props.add("copyTo");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("searchTerm");
        props.add("alternativeBodyHeader");
        props.add("mimeDecodeHeaders");
        props.add("host");
        props.add("attachmentsContentTransferEncodingResolver");
        props.add("skipFailedMessage");
        props.add("greedy");
        props.add("maxMessagesPerPoll");
        props.add("from");
        props.add("scheduledExecutorService");
        props.add("contentType");
        props.add("repeatCount");
        props.add("postProcessAction");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("sortTerm");
        props.add("idempotentRepositoryRemoveOnCommit");
        props.add("backoffIdleThreshold");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("port");
        props.add("startScheduler");
        props.add("replyTo");
        props.add("mailUidGenerator");
        props.add("folderName");
        props.add("exceptionHandler");
        props.add("debugMode");
        props.add("backoffMultiplier");
        props.add("bcc");
        props.add("session");
        props.add("sslContextParameters");
        props.add("mapMailMessage");
        props.add("delete");
        props.add("handleFailedMessage");
        props.add("scheduler");
        props.add("closeFolder");
        props.add("additionalJavaMailProperties");
        props.add("useFixedDelay");
        props.add("headerFilterStrategy");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("authenticator");
        props.add("connectionTimeout");
        props.add("timeUnit");
        props.add("cc");
        props.add("fetchSize");
        props.add("javaMailSender");
        props.add("useInlineAttachments");
        props.add("idempotentRepository");
        props.add("exchangePattern");
        props.add("ignoreUnsupportedCharset");
        props.add("ignoreUriScheme");
        props.add("peek");
        props.add("pollStrategy");
        props.add("decodeFilename");
        props.add("to");
        props.add("javaMailProperties");
        props.add("unseen");
        props.add("moveTo");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

