/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class MailMessage
extends DefaultMessage {
    private javax.mail.Message originalMailMessage;
    private javax.mail.Message mailMessage;
    private boolean mapMailMessage;

    public MailMessage(Exchange exchange, javax.mail.Message message, boolean mapMailMessage) {
        super(exchange);
        this.originalMailMessage = this.mailMessage = message;
        this.mapMailMessage = mapMailMessage;
    }

    public String toString() {
        return "MailMessage@" + ObjectHelper.getIdentityHashCode((Object)((Object)this));
    }

    public MailMessage copy() {
        MailMessage answer = (MailMessage)super.copy();
        answer.originalMailMessage = this.originalMailMessage;
        answer.mailMessage = this.mailMessage;
        return answer;
    }

    public javax.mail.Message getOriginalMessage() {
        return this.originalMailMessage;
    }

    public javax.mail.Message getMessage() {
        return this.mailMessage;
    }

    public void setMessage(javax.mail.Message mailMessage) {
        if (this.originalMailMessage == null) {
            this.originalMailMessage = mailMessage;
        }
        this.mailMessage = mailMessage;
    }

    public MailMessage newInstance() {
        MailMessage answer = new MailMessage(null, null, this.mapMailMessage);
        answer.setCamelContext(this.getCamelContext());
        return answer;
    }

    protected Object createBody() {
        if (this.mailMessage != null) {
            MailBinding binding = (MailBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), MailBinding.class);
            return binding != null ? binding.extractBodyFromMail(this.getExchange(), this) : null;
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.mailMessage != null) {
            try {
                MailBinding binding = (MailBinding)ExchangeHelper.getBinding((Exchange)this.getExchange(), MailBinding.class);
                if (binding != null) {
                    map.putAll(binding.extractHeadersFromMail(this.mailMessage, this.getExchange()));
                }
            }
            catch (IOException | MessagingException e) {
                throw new RuntimeCamelException("Error accessing headers due to: " + e.getMessage(), e);
            }
        }
    }

    public void copyFrom(Message that) {
        boolean needCopy;
        boolean bl = needCopy = !(that instanceof MailMessage) || ((MailMessage)that).mapMailMessage;
        if (needCopy) {
            super.copyFrom(that);
        } else {
            this.setMessageId(that.getMessageId());
        }
        if (that instanceof MailMessage) {
            MailMessage tmpMailMessage = (MailMessage)that;
            this.originalMailMessage = tmpMailMessage.originalMailMessage;
            this.mailMessage = tmpMailMessage.mailMessage;
            this.mapMailMessage = tmpMailMessage.mapMailMessage;
        }
        if (this.getExchange() == null) {
            this.setExchange(that.getExchange());
        }
    }
}

