/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.TypeConverters;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.engine.PooledExchangeFactory;
import org.apache.camel.impl.engine.PooledProcessorExchangeFactory;
import org.apache.camel.impl.engine.PrototypeExchangeFactory;
import org.apache.camel.impl.engine.PrototypeProcessorExchangeFactory;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.ClassicUuidGenerator;
import org.apache.camel.support.DefaultUuidGenerator;
import org.apache.camel.support.OffUuidGenerator;
import org.apache.camel.support.RouteWatcherReloadStrategy;
import org.apache.camel.support.ShortUuidGenerator;
import org.apache.camel.support.SimpleUuidGenerator;
import org.apache.camel.support.jsse.GlobalSSLContextParametersSupplier;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultConfigurationConfigurer {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurationConfigurer.class);

    private DefaultConfigurationConfigurer() {
    }

    public static void configure(CamelContext camelContext, DefaultConfigurationProperties<?> config) throws Exception {
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
        if (config.getStartupRecorder() != null) {
            if ("false".equals(config.getStartupRecorder())) {
                ecc.getStartupStepRecorder().setEnabled(false);
            } else if ("logging".equals(config.getStartupRecorder())) {
                if (!(ecc.getStartupStepRecorder() instanceof LoggingStartupStepRecorder)) {
                    ecc.setStartupStepRecorder((StartupStepRecorder)new LoggingStartupStepRecorder());
                }
            } else if ("java-flight-recorder".equals(config.getStartupRecorder()) && !ecc.getStartupStepRecorder().getClass().getName().startsWith("org.apache.camel.startup.jfr")) {
                throw new IllegalArgumentException("Cannot find Camel Java Flight Recorder on classpath. Add camel-jfr to classpath.");
            }
        }
        ecc.getStartupStepRecorder().setMaxDepth(config.getStartupRecorderMaxDepth());
        ecc.getStartupStepRecorder().setRecording(config.isStartupRecorderRecording());
        ecc.getStartupStepRecorder().setStartupRecorderDuration(config.getStartupRecorderDuration());
        ecc.getStartupStepRecorder().setRecordingDir(config.getStartupRecorderDir());
        ecc.getStartupStepRecorder().setRecordingProfile(config.getStartupRecorderProfile());
        ecc.setLightweight(config.isLightweight());
        ecc.getBeanPostProcessor().setEnabled(config.isBeanPostProcessorEnabled());
        ecc.getBeanIntrospection().setExtendedStatistics(config.isBeanIntrospectionExtendedStatistics());
        if (config.getBeanIntrospectionLoggingLevel() != null) {
            ecc.getBeanIntrospection().setLoggingLevel(config.getBeanIntrospectionLoggingLevel());
        }
        ecc.getBeanIntrospection().afterPropertiesConfigured(camelContext);
        if ("pooled".equals(config.getExchangeFactory())) {
            ecc.setExchangeFactory((ExchangeFactory)new PooledExchangeFactory());
            ecc.setProcessorExchangeFactory((ProcessorExchangeFactory)new PooledProcessorExchangeFactory());
        } else if ("prototype".equals(config.getExchangeFactory())) {
            ecc.setExchangeFactory((ExchangeFactory)new PrototypeExchangeFactory());
            ecc.setProcessorExchangeFactory((ProcessorExchangeFactory)new PrototypeProcessorExchangeFactory());
        }
        ecc.getExchangeFactory().setCapacity(config.getExchangeFactoryCapacity());
        ecc.getProcessorExchangeFactory().setCapacity(config.getExchangeFactoryCapacity());
        ecc.getExchangeFactory().setStatisticsEnabled(config.isExchangeFactoryStatisticsEnabled());
        ecc.getProcessorExchangeFactory().setStatisticsEnabled(config.isExchangeFactoryStatisticsEnabled());
        if (!config.isJmxEnabled()) {
            camelContext.disableJMX();
        }
        if (config.getName() != null) {
            ecc.setName(config.getName());
        }
        if (config.getStartupSummaryLevel() != null) {
            camelContext.setStartupSummaryLevel(config.getStartupSummaryLevel());
        }
        if (config.getShutdownTimeout() > 0) {
            camelContext.getShutdownStrategy().setTimeout((long)config.getShutdownTimeout());
        }
        camelContext.getShutdownStrategy().setSuppressLoggingOnTimeout(config.isShutdownSuppressLoggingOnTimeout());
        camelContext.getShutdownStrategy().setShutdownNowOnTimeout(config.isShutdownNowOnTimeout());
        camelContext.getShutdownStrategy().setShutdownRoutesInReverseOrder(config.isShutdownRoutesInReverseOrder());
        camelContext.getShutdownStrategy().setLogInflightExchangesOnTimeout(config.isShutdownLogInflightExchangesOnTimeout());
        camelContext.getInflightRepository().setInflightBrowseEnabled(config.isInflightRepositoryBrowseEnabled());
        if (config.getLogDebugMaxChars() != 0) {
            camelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", "" + config.getLogDebugMaxChars());
        }
        camelContext.setStreamCaching(Boolean.valueOf(config.isStreamCachingEnabled()));
        camelContext.getStreamCachingStrategy().setAnySpoolRules(config.isStreamCachingAnySpoolRules());
        camelContext.getStreamCachingStrategy().setBufferSize(config.getStreamCachingBufferSize());
        camelContext.getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(config.isStreamCachingRemoveSpoolDirectoryWhenStopping());
        camelContext.getStreamCachingStrategy().setSpoolCipher(config.getStreamCachingSpoolCipher());
        if (config.getStreamCachingSpoolDirectory() != null) {
            camelContext.getStreamCachingStrategy().setSpoolDirectory(config.getStreamCachingSpoolDirectory());
        }
        if (config.getStreamCachingSpoolThreshold() != 0L) {
            camelContext.getStreamCachingStrategy().setSpoolThreshold(config.getStreamCachingSpoolThreshold());
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryLimit() != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit;
            if ("Committed".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed;
            } else if ("Max".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
            } else {
                throw new IllegalArgumentException("Invalid option " + config.getStreamCachingSpoolUsedHeapMemoryLimit() + " must either be Committed or Max");
            }
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(limit);
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryThreshold() != 0) {
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(config.getStreamCachingSpoolUsedHeapMemoryThreshold());
        }
        if ("default".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new DefaultUuidGenerator());
        } else if ("short".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new ShortUuidGenerator());
        } else if ("classic".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new ClassicUuidGenerator());
        } else if ("simple".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new SimpleUuidGenerator());
        } else if ("off".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator((UuidGenerator)new OffUuidGenerator());
            LOG.warn("Using OffUuidGenerator (Only intended for development purposes)");
        }
        camelContext.setMessageHistory(Boolean.valueOf(config.isMessageHistory()));
        camelContext.setLogMask(Boolean.valueOf(config.isLogMask()));
        camelContext.setLogExhaustedMessageBody(Boolean.valueOf(config.isLogExhaustedMessageBody()));
        camelContext.setAutoStartup(Boolean.valueOf(config.isAutoStartup()));
        camelContext.setAllowUseOriginalMessage(Boolean.valueOf(config.isAllowUseOriginalMessage()));
        camelContext.setCaseInsensitiveHeaders(Boolean.valueOf(config.isCaseInsensitiveHeaders()));
        camelContext.setAutowiredEnabled(Boolean.valueOf(config.isAutowiredEnabled()));
        camelContext.setUseBreadcrumb(Boolean.valueOf(config.isUseBreadcrumb()));
        camelContext.setUseDataType(Boolean.valueOf(config.isUseDataType()));
        camelContext.setDumpRoutes(Boolean.valueOf(config.isDumpRoutes()));
        camelContext.setUseMDCLogging(Boolean.valueOf(config.isUseMdcLogging()));
        camelContext.setMDCLoggingKeysPattern(config.getMdcLoggingKeysPattern());
        camelContext.setLoadTypeConverters(Boolean.valueOf(config.isLoadTypeConverters()));
        camelContext.setLoadHealthChecks(Boolean.valueOf(config.isLoadHealthChecks()));
        if (config.isRoutesReloadEnabled()) {
            RouteWatcherReloadStrategy reloader = new RouteWatcherReloadStrategy(config.getRoutesReloadDirectory(), config.isRoutesReloadDirectoryRecursive());
            reloader.setPattern(config.getRoutesReloadPattern());
            reloader.setRemoveAllRoutes(config.isRoutesReloadRemoveAllRoutes());
            camelContext.addService((Object)reloader);
        }
        if (camelContext.getManagementStrategy().getManagementAgent() != null) {
            camelContext.getManagementStrategy().getManagementAgent().setEndpointRuntimeStatisticsEnabled(Boolean.valueOf(config.isEndpointRuntimeStatisticsEnabled()));
            camelContext.getManagementStrategy().getManagementAgent().setStatisticsLevel(config.getJmxManagementStatisticsLevel());
            camelContext.getManagementStrategy().getManagementAgent().setManagementNamePattern(config.getJmxManagementNamePattern());
        }
        if (config.getGlobalOptions() != null) {
            HashMap<String, String> map = camelContext.getGlobalOptions();
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.putAll(config.getGlobalOptions());
            camelContext.setGlobalOptions(map);
        }
        camelContext.getGlobalEndpointConfiguration().setAutowiredEnabled(config.isAutowiredEnabled());
        camelContext.getGlobalEndpointConfiguration().setBridgeErrorHandler(config.isEndpointBridgeErrorHandler());
        camelContext.getGlobalEndpointConfiguration().setLazyStartProducer(config.isEndpointLazyStartProducer());
        camelContext.setBacklogTracing(Boolean.valueOf(config.isBacklogTracing()));
        camelContext.setTracing(Boolean.valueOf(config.isTracing()));
        camelContext.setTracingStandby(config.isTracingStandby());
        camelContext.setTracingPattern(config.getTracingPattern());
        if (config.getThreadNamePattern() != null) {
            camelContext.getExecutorServiceManager().setThreadNamePattern(config.getThreadNamePattern());
        }
        if (config.getRouteFilterIncludePattern() != null || config.getRouteFilterExcludePattern() != null) {
            ((Model)camelContext.getExtension(Model.class)).setRouteFilterPattern(config.getRouteFilterIncludePattern(), config.getRouteFilterExcludePattern());
        }
        if (config.isRouteControllerSuperviseEnabled()) {
            SupervisingRouteController src = camelContext.getRouteController().supervising();
            if (config.getRouteControllerIncludeRoutes() != null) {
                src.setIncludeRoutes(config.getRouteControllerIncludeRoutes());
            }
            if (config.getRouteControllerExcludeRoutes() != null) {
                src.setExcludeRoutes(config.getRouteControllerExcludeRoutes());
            }
            if (config.getRouteControllerThreadPoolSize() > 0) {
                src.setThreadPoolSize(config.getRouteControllerThreadPoolSize());
            }
            if (config.getRouteControllerBackOffDelay() > 0L) {
                src.setBackOffDelay(config.getRouteControllerBackOffDelay());
            }
            if (config.getRouteControllerInitialDelay() > 0L) {
                src.setInitialDelay(config.getRouteControllerInitialDelay());
            }
            if (config.getRouteControllerBackOffMaxAttempts() > 0L) {
                src.setBackOffMaxAttempts(config.getRouteControllerBackOffMaxAttempts());
            }
            if (config.getRouteControllerBackOffMaxDelay() > 0L) {
                src.setBackOffMaxDelay(config.getRouteControllerBackOffDelay());
            }
            if (config.getRouteControllerBackOffMaxElapsedTime() > 0L) {
                src.setBackOffMaxElapsedTime(config.getRouteControllerBackOffMaxElapsedTime());
            }
            if (config.getRouteControllerBackOffMultiplier() > 0.0) {
                src.setBackOffMultiplier(config.getRouteControllerBackOffMultiplier());
            }
            src.setUnhealthyOnExhausted(config.isRouteControllerUnhealthyOnExhausted());
        }
        if (config.getRouteControllerLoggingLevel() != null) {
            camelContext.getRouteController().setLoggingLevel(config.getRouteControllerLoggingLevel());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void afterConfigure(CamelContext camelContext) throws Exception {
        Set repositories;
        void var40_44;
        HealthCheckRegistry healthCheckRegistry;
        GlobalSSLContextParametersSupplier sslContextParametersSupplier;
        Map serviceRegistries;
        Set rpfs;
        Set csss;
        Set ess;
        Set tcs;
        ExchangeFactory exf;
        ShutdownStrategy ss;
        ReactiveExecutor re;
        MessageHistoryFactory mhf;
        NodeIdFactory nif;
        Debugger debugger;
        ProcessorFactory pf;
        ThreadPoolFactory tpf;
        ExecutorServiceManager esm;
        UuidGenerator ug;
        RouteController rc;
        FactoryFinderResolver ffr;
        ClassResolver cr;
        ModelJAXBContextFactory mjcf;
        RuntimeEndpointRegistry rer;
        UnitOfWorkFactory uowf;
        EventFactory ef;
        ManagementObjectNameStrategy mons;
        ManagementStrategy ms;
        AsyncProcessorAwaitManager apam;
        InflightRepository ir;
        BacklogTracer bt;
        PropertiesComponent pc;
        Registry registry = camelContext.getRegistry();
        ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
        StartupStepRecorder ssr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, StartupStepRecorder.class);
        if (ssr != null) {
            ecc.setStartupStepRecorder(ssr);
        }
        if ((pc = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, PropertiesComponent.class)) != null) {
            ecc.setPropertiesComponent(pc);
        }
        if ((bt = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, BacklogTracer.class)) != null) {
            ecc.setExtension(BacklogTracer.class, (Object)bt);
        }
        if ((ir = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, InflightRepository.class)) != null) {
            ecc.setInflightRepository(ir);
        }
        if ((apam = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, AsyncProcessorAwaitManager.class)) != null) {
            ecc.setAsyncProcessorAwaitManager(apam);
        }
        if ((ms = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ManagementStrategy.class)) != null) {
            ecc.setManagementStrategy(ms);
        }
        if ((mons = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ManagementObjectNameStrategy.class)) != null) {
            managementStrategy.setManagementObjectNameStrategy(mons);
        }
        if ((ef = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, EventFactory.class)) != null) {
            managementStrategy.setEventFactory(ef);
        }
        if ((uowf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, UnitOfWorkFactory.class)) != null) {
            ecc.setUnitOfWorkFactory(uowf);
        }
        if ((rer = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, RuntimeEndpointRegistry.class)) != null) {
            ecc.setRuntimeEndpointRegistry(rer);
        }
        if ((mjcf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ModelJAXBContextFactory.class)) != null) {
            ecc.setModelJAXBContextFactory(mjcf);
        }
        if ((cr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ClassResolver.class)) != null) {
            ecc.setClassResolver(cr);
        }
        if ((ffr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, FactoryFinderResolver.class)) != null) {
            ecc.setFactoryFinderResolver(ffr);
        }
        if ((rc = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, RouteController.class)) != null) {
            ecc.setRouteController(rc);
        }
        if ((ug = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, UuidGenerator.class)) != null) {
            ecc.setUuidGenerator(ug);
        }
        if ((esm = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ExecutorServiceManager.class)) != null) {
            ecc.setExecutorServiceManager(esm);
        }
        if ((tpf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ThreadPoolFactory.class)) != null) {
            ecc.getExecutorServiceManager().setThreadPoolFactory(tpf);
        }
        if ((pf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ProcessorFactory.class)) != null) {
            ecc.setProcessorFactory(pf);
        }
        if ((debugger = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, Debugger.class)) != null) {
            ecc.setDebugger(debugger);
        }
        if ((nif = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, NodeIdFactory.class)) != null) {
            ecc.setNodeIdFactory(nif);
        }
        if ((mhf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, MessageHistoryFactory.class)) != null) {
            ecc.setMessageHistoryFactory(mhf);
        }
        if ((re = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ReactiveExecutor.class)) != null) {
            ecc.setReactiveExecutor(re);
        }
        if ((ss = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ShutdownStrategy.class)) != null) {
            ecc.setShutdownStrategy(ss);
        }
        if ((exf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ExchangeFactory.class)) != null) {
            ecc.setExchangeFactory(exf);
        }
        if (!(tcs = registry.findByType(TypeConverters.class)).isEmpty()) {
            tcs.forEach(t -> camelContext.getTypeConverterRegistry().addTypeConverters(t));
        }
        if (!(ess = registry.findByType(EndpointStrategy.class)).isEmpty()) {
            ess.forEach(arg_0 -> ((ExtendedCamelContext)ecc).registerEndpointCallback(arg_0));
        }
        if (!(csss = registry.findByType(CamelClusterService.class)).isEmpty()) {
            for (CamelClusterService css : csss) {
                camelContext.addService((Object)css);
            }
        }
        if (!(rpfs = registry.findByType(RoutePolicyFactory.class)).isEmpty()) {
            rpfs.forEach(arg_0 -> ((CamelContext)camelContext).addRoutePolicyFactory(arg_0));
        }
        Predicate<EventNotifier> containsEventNotifier = managementStrategy.getEventNotifiers()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, EventNotifier.class, containsEventNotifier.negate(), arg_0 -> ((ManagementStrategy)managementStrategy).addEventNotifier(arg_0));
        Predicate<InterceptStrategy> containsInterceptStrategy = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getInterceptStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, InterceptStrategy.class, containsInterceptStrategy.negate(), arg_0 -> ((ExtendedCamelContext)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class))).addInterceptStrategy(arg_0));
        Predicate<LifecycleStrategy> containsLifecycleStrategy = camelContext.getLifecycleStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, LifecycleStrategy.class, containsLifecycleStrategy.negate(), arg_0 -> ((CamelContext)camelContext).addLifecycleStrategy(arg_0));
        ModelCamelContext mcc = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
        Predicate<ModelLifecycleStrategy> containsModelLifecycleStrategy = mcc.getModelLifecycleStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, ModelLifecycleStrategy.class, containsModelLifecycleStrategy.negate(), arg_0 -> ((ModelCamelContext)mcc).addModelLifecycleStrategy(arg_0));
        Map logListeners = registry.findByTypeWithName(LogListener.class);
        if (logListeners != null && !logListeners.isEmpty()) {
            for (LogListener logListener : logListeners.values()) {
                boolean bl = ecc.getLogListeners() != null && ecc.getLogListeners().contains(logListener);
                if (bl) continue;
                ecc.addLogListener(logListener);
            }
        }
        if ((serviceRegistries = registry.findByTypeWithName(ServiceRegistry.class)) != null && !serviceRegistries.isEmpty()) {
            for (Map.Entry entry : serviceRegistries.entrySet()) {
                ServiceRegistry service = (ServiceRegistry)entry.getValue();
                if (service.getId() == null) {
                    service.setGeneratedId(camelContext.getUuidGenerator().generateUuid());
                }
                LOG.info("Adding Camel Cloud ServiceRegistry with id: {} and implementation: {}", (Object)service.getId(), (Object)service);
                camelContext.addService((Object)service);
            }
        }
        if ((sslContextParametersSupplier = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, GlobalSSLContextParametersSupplier.class)) != null) {
            camelContext.setSSLContextParameters((SSLContextParameters)sslContextParametersSupplier.get());
        }
        if ((healthCheckRegistry = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, HealthCheckRegistry.class)) != null) {
            healthCheckRegistry.setCamelContext(camelContext);
            LOG.debug("Using HealthCheckRegistry: {}", (Object)healthCheckRegistry);
            camelContext.setExtension(HealthCheckRegistry.class, (Object)healthCheckRegistry);
        } else {
            HealthCheckRegistry healthCheckRegistry2 = HealthCheckRegistry.get((CamelContext)camelContext);
            if (healthCheckRegistry2 != null) {
                healthCheckRegistry2.setCamelContext(camelContext);
            }
        }
        if (var40_44 != null && ObjectHelper.isNotEmpty((Object)(repositories = registry.findByType(HealthCheckRepository.class)))) {
            for (HealthCheckRepository repository : repositories) {
                var40_44.register((Object)repository);
            }
        }
        DefaultConfigurationConfigurer.initThreadPoolProfiles(registry, camelContext);
    }

    public static void afterPropertiesSet(CamelContext camelContext) throws Exception {
    }

    private static <T> T getSingleBeanOfType(Registry registry, Class<T> type) {
        Map beans = registry.findByTypeWithName(type);
        if (beans.size() == 1) {
            return (T)beans.values().iterator().next();
        }
        return null;
    }

    private static <T> void registerPropertiesForBeanTypesWithCondition(Registry registry, Class<T> beanType, Predicate<T> condition, Consumer<T> propertySetter) {
        Map beans = registry.findByTypeWithName(beanType);
        if (!ObjectHelper.isNotEmpty((Object)beans)) {
            return;
        }
        String simpleName = beanType.getSimpleName();
        beans.forEach((name, bean) -> {
            if (condition.test(bean)) {
                LOG.info("Adding custom {} with id: {} and implementation: {}", new Object[]{simpleName, name, bean});
                propertySetter.accept(bean);
            }
        });
    }

    private static void initThreadPoolProfiles(Registry registry, CamelContext camelContext) {
        HashSet<String> defaultIds = new HashSet<String>();
        Map profiles = registry.findByTypeWithName(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry entry : profiles.entrySet()) {
                ThreadPoolProfile profile = (ThreadPoolProfile)entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", entry.getKey(), (Object)profile);
                    camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add((String)entry.getKey());
                    continue;
                }
                camelContext.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }
}

