/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.camel.CamelConfiguration;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.DebuggerConfigurationProperties;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.main.FaultToleranceConfigurationProperties;
import org.apache.camel.main.HealthConfigurationProperties;
import org.apache.camel.main.HttpServerConfigurationProperties;
import org.apache.camel.main.LraConfigurationProperties;
import org.apache.camel.main.MetricsConfigurationProperties;
import org.apache.camel.main.OtelConfigurationProperties;
import org.apache.camel.main.Resilience4jConfigurationProperties;
import org.apache.camel.main.RestConfigurationProperties;
import org.apache.camel.main.SSLConfigurationProperties;
import org.apache.camel.main.ThreadPoolConfigurationProperties;
import org.apache.camel.main.VaultConfigurationProperties;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.Configurer;

@Configurer(bootstrap=true)
public class MainConfigurationProperties
extends DefaultConfigurationProperties<MainConfigurationProperties>
implements BootstrapCloseable {
    private boolean autoConfigurationEnabled = true;
    private boolean autoConfigurationEnvironmentVariablesEnabled = true;
    private boolean autoConfigurationSystemPropertiesEnabled = true;
    private boolean autoConfigurationFailFast = true;
    private boolean autoConfigurationLogSummary = true;
    private int durationHitExitCode;
    private int extraShutdownTimeout = 15;
    private String basePackageScan;
    private boolean basePackageScanEnabled = true;
    private String routesBuilderClasses;
    private String configurationClasses;
    private List<RoutesBuilder> routesBuilders = new ArrayList<RoutesBuilder>();
    private List<CamelConfiguration> configurations = new ArrayList<CamelConfiguration>();
    private HealthConfigurationProperties healthConfigurationProperties;
    private LraConfigurationProperties lraConfigurationProperties;
    private OtelConfigurationProperties otelConfigurationProperties;
    private MetricsConfigurationProperties metricsConfigurationProperties;
    private ThreadPoolConfigurationProperties threadPoolProperties;
    private Resilience4jConfigurationProperties resilience4jConfigurationProperties;
    private FaultToleranceConfigurationProperties faultToleranceConfigurationProperties;
    private RestConfigurationProperties restConfigurationProperties;
    private VaultConfigurationProperties vaultConfigurationProperties;
    private HttpServerConfigurationProperties httpServerConfigurationProperties;
    private SSLConfigurationProperties sslConfigurationProperties;
    private DebuggerConfigurationProperties debuggerConfigurationProperties;

    public void close() {
        if (this.healthConfigurationProperties != null) {
            this.healthConfigurationProperties.close();
            this.healthConfigurationProperties = null;
        }
        if (this.lraConfigurationProperties != null) {
            this.lraConfigurationProperties.close();
            this.lraConfigurationProperties = null;
        }
        if (this.otelConfigurationProperties != null) {
            this.otelConfigurationProperties.close();
            this.otelConfigurationProperties = null;
        }
        if (this.metricsConfigurationProperties != null) {
            this.metricsConfigurationProperties.close();
            this.metricsConfigurationProperties = null;
        }
        if (this.threadPoolProperties != null) {
            this.threadPoolProperties.close();
            this.threadPoolProperties = null;
        }
        if (this.resilience4jConfigurationProperties != null) {
            this.resilience4jConfigurationProperties.close();
            this.resilience4jConfigurationProperties = null;
        }
        if (this.faultToleranceConfigurationProperties != null) {
            this.faultToleranceConfigurationProperties.close();
            this.faultToleranceConfigurationProperties = null;
        }
        if (this.restConfigurationProperties != null) {
            this.restConfigurationProperties.close();
            this.restConfigurationProperties = null;
        }
        if (this.vaultConfigurationProperties != null) {
            this.vaultConfigurationProperties.close();
            this.vaultConfigurationProperties = null;
        }
        if (this.httpServerConfigurationProperties != null) {
            this.httpServerConfigurationProperties.close();
            this.httpServerConfigurationProperties = null;
        }
        if (this.sslConfigurationProperties != null) {
            this.sslConfigurationProperties.close();
            this.sslConfigurationProperties = null;
        }
        if (this.debuggerConfigurationProperties != null) {
            this.debuggerConfigurationProperties.close();
            this.debuggerConfigurationProperties = null;
        }
        if (this.routesBuilders != null) {
            this.routesBuilders.clear();
            this.routesBuilders = null;
        }
        if (this.configurations != null) {
            this.configurations.clear();
            this.configurations = null;
        }
    }

    public HealthConfigurationProperties health() {
        if (this.healthConfigurationProperties == null) {
            this.healthConfigurationProperties = new HealthConfigurationProperties(this);
        }
        return this.healthConfigurationProperties;
    }

    public boolean hasHealthCheckConfiguration() {
        return this.healthConfigurationProperties != null;
    }

    public LraConfigurationProperties lra() {
        if (this.lraConfigurationProperties == null) {
            this.lraConfigurationProperties = new LraConfigurationProperties(this);
        }
        return this.lraConfigurationProperties;
    }

    public boolean hasLraConfiguration() {
        return this.lraConfigurationProperties != null;
    }

    public OtelConfigurationProperties otel() {
        if (this.otelConfigurationProperties == null) {
            this.otelConfigurationProperties = new OtelConfigurationProperties(this);
        }
        return this.otelConfigurationProperties;
    }

    public boolean hasOtelConfiguration() {
        return this.otelConfigurationProperties != null;
    }

    public MetricsConfigurationProperties metrics() {
        if (this.metricsConfigurationProperties == null) {
            this.metricsConfigurationProperties = new MetricsConfigurationProperties(this);
        }
        return this.metricsConfigurationProperties;
    }

    public boolean hasMetricsConfiguration() {
        return this.metricsConfigurationProperties != null;
    }

    public HttpServerConfigurationProperties httpServer() {
        if (this.httpServerConfigurationProperties == null) {
            this.httpServerConfigurationProperties = new HttpServerConfigurationProperties(this);
        }
        return this.httpServerConfigurationProperties;
    }

    public boolean hasHttpServerConfiguration() {
        return this.httpServerConfigurationProperties != null;
    }

    public SSLConfigurationProperties sslConfig() {
        if (this.sslConfigurationProperties == null) {
            this.sslConfigurationProperties = new SSLConfigurationProperties(this);
        }
        return this.sslConfigurationProperties;
    }

    public DebuggerConfigurationProperties debuggerConfig() {
        if (this.debuggerConfigurationProperties == null) {
            this.debuggerConfigurationProperties = new DebuggerConfigurationProperties(this);
        }
        return this.debuggerConfigurationProperties;
    }

    public boolean hasSslConfiguration() {
        return this.sslConfigurationProperties != null;
    }

    public boolean hasDebuggerConfiguration() {
        return this.debuggerConfigurationProperties != null;
    }

    public ThreadPoolConfigurationProperties threadPool() {
        if (this.threadPoolProperties == null) {
            this.threadPoolProperties = new ThreadPoolConfigurationProperties(this);
        }
        return this.threadPoolProperties;
    }

    public boolean hasThreadPoolConfiguration() {
        return this.threadPoolProperties != null;
    }

    public Resilience4jConfigurationProperties resilience4j() {
        if (this.resilience4jConfigurationProperties == null) {
            this.resilience4jConfigurationProperties = new Resilience4jConfigurationProperties(this);
        }
        return this.resilience4jConfigurationProperties;
    }

    public boolean hasResilience4jConfiguration() {
        return this.resilience4jConfigurationProperties != null;
    }

    public FaultToleranceConfigurationProperties faultTolerance() {
        if (this.faultToleranceConfigurationProperties == null) {
            this.faultToleranceConfigurationProperties = new FaultToleranceConfigurationProperties(this);
        }
        return this.faultToleranceConfigurationProperties;
    }

    public boolean hasFaultToleranceConfiguration() {
        return this.faultToleranceConfigurationProperties != null;
    }

    public RestConfigurationProperties rest() {
        if (this.restConfigurationProperties == null) {
            this.restConfigurationProperties = new RestConfigurationProperties(this);
        }
        return this.restConfigurationProperties;
    }

    public boolean hasRestConfiguration() {
        return this.restConfigurationProperties != null;
    }

    public VaultConfigurationProperties vault() {
        if (this.vaultConfigurationProperties == null) {
            this.vaultConfigurationProperties = new VaultConfigurationProperties(this);
        }
        return this.vaultConfigurationProperties;
    }

    public boolean hasVaultConfiguration() {
        return this.vaultConfigurationProperties != null;
    }

    public boolean isAutoConfigurationEnabled() {
        return this.autoConfigurationEnabled;
    }

    public void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.autoConfigurationEnabled = autoConfigurationEnabled;
    }

    public boolean isAutoConfigurationEnvironmentVariablesEnabled() {
        return this.autoConfigurationEnvironmentVariablesEnabled;
    }

    public void setAutoConfigurationEnvironmentVariablesEnabled(boolean autoConfigurationEnvironmentVariablesEnabled) {
        this.autoConfigurationEnvironmentVariablesEnabled = autoConfigurationEnvironmentVariablesEnabled;
    }

    public boolean isAutoConfigurationSystemPropertiesEnabled() {
        return this.autoConfigurationSystemPropertiesEnabled;
    }

    public void setAutoConfigurationSystemPropertiesEnabled(boolean autoConfigurationSystemPropertiesEnabled) {
        this.autoConfigurationSystemPropertiesEnabled = autoConfigurationSystemPropertiesEnabled;
    }

    public boolean isAutoConfigurationFailFast() {
        return this.autoConfigurationFailFast;
    }

    public void setAutoConfigurationFailFast(boolean autoConfigurationFailFast) {
        this.autoConfigurationFailFast = autoConfigurationFailFast;
    }

    public boolean isAutoConfigurationLogSummary() {
        return this.autoConfigurationLogSummary;
    }

    public void setAutoConfigurationLogSummary(boolean autoConfigurationLogSummary) {
        this.autoConfigurationLogSummary = autoConfigurationLogSummary;
    }

    public String getBasePackageScan() {
        return this.basePackageScan;
    }

    public void setBasePackageScan(String basePackageScan) {
        this.basePackageScan = basePackageScan;
    }

    public boolean isBasePackageScanEnabled() {
        return this.basePackageScanEnabled;
    }

    public void setBasePackageScanEnabled(boolean basePackageScanEnabled) {
        this.basePackageScanEnabled = basePackageScanEnabled;
    }

    public int getDurationHitExitCode() {
        return this.durationHitExitCode;
    }

    public void setDurationHitExitCode(int durationHitExitCode) {
        this.durationHitExitCode = durationHitExitCode;
    }

    public int getExtraShutdownTimeout() {
        return this.extraShutdownTimeout;
    }

    public void setExtraShutdownTimeout(int extraShutdownTimeout) {
        this.extraShutdownTimeout = extraShutdownTimeout;
    }

    public String getConfigurationClasses() {
        return this.configurationClasses;
    }

    public void setConfigurationClasses(String configurations) {
        this.configurationClasses = configurations;
    }

    private void addConfigurationClass(Class<? extends CamelConfiguration> ... configuration) {
        StringJoiner existing = new StringJoiner(",");
        if (this.configurationClasses != null && !this.configurationClasses.isEmpty()) {
            existing.add(this.configurationClasses);
        }
        if (configuration != null) {
            for (Class<? extends CamelConfiguration> clazz : configuration) {
                existing.add(clazz.getName());
            }
        }
        this.setConfigurationClasses(existing.toString());
    }

    public void addConfiguration(CamelConfiguration configuration) {
        this.configurations.add(configuration);
    }

    public void addConfiguration(Class<? extends CamelConfiguration> configuration) {
        this.addConfigurationClass(configuration);
    }

    public List<CamelConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<CamelConfiguration> configurations) {
        this.configurations = configurations;
    }

    public String getRoutesBuilderClasses() {
        return this.routesBuilderClasses;
    }

    public void setRoutesBuilderClasses(String builders) {
        this.routesBuilderClasses = builders;
    }

    public List<RoutesBuilder> getRoutesBuilders() {
        return this.routesBuilders;
    }

    public void setRoutesBuilders(List<RoutesBuilder> routesBuilders) {
        this.routesBuilders = routesBuilders;
    }

    public void addRoutesBuilder(RoutesBuilder routeBuilder) {
        this.routesBuilders.add(routeBuilder);
    }

    public void addRoutesBuilder(Class<?> ... routeBuilder) {
        StringJoiner existing = new StringJoiner(",");
        if (this.routesBuilderClasses != null && !this.routesBuilderClasses.isEmpty()) {
            existing.add(this.routesBuilderClasses);
        }
        if (routeBuilder != null) {
            for (Class<?> clazz : routeBuilder) {
                existing.add(clazz.getName());
            }
        }
        this.setRoutesBuilderClasses(existing.toString());
    }

    public void addLambdaRouteBuilder(final LambdaRouteBuilder routeBuilder) {
        this.routesBuilders.add((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                routeBuilder.accept((Object)this);
            }
        });
    }

    public MainConfigurationProperties withAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.autoConfigurationEnabled = autoConfigurationEnabled;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationEnvironmentVariablesEnabled(boolean autoConfigurationEnvironmentVariablesEnabled) {
        this.autoConfigurationEnvironmentVariablesEnabled = autoConfigurationEnvironmentVariablesEnabled;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationSystemPropertiesEnabled(boolean autoConfigurationSystemPropertiesEnabled) {
        this.autoConfigurationSystemPropertiesEnabled = autoConfigurationSystemPropertiesEnabled;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationFailFast(boolean autoConfigurationFailFast) {
        this.autoConfigurationFailFast = autoConfigurationFailFast;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationLogSummary(boolean autoConfigurationLogSummary) {
        this.autoConfigurationLogSummary = autoConfigurationLogSummary;
        return this;
    }

    public MainConfigurationProperties withDurationHitExitCode(int durationHitExitCode) {
        this.durationHitExitCode = durationHitExitCode;
        return this;
    }

    public MainConfigurationProperties withExtraShutdownTimeout(int extraShutdownTimeout) {
        this.extraShutdownTimeout = extraShutdownTimeout;
        return this;
    }

    public MainConfigurationProperties withBasePackageScan(String basePackageScan) {
        this.basePackageScan = basePackageScan;
        return this;
    }

    public MainConfigurationProperties withBasePackageScanEnabled(boolean basePackageScanEnabled) {
        this.basePackageScanEnabled = basePackageScanEnabled;
        return this;
    }

    public MainConfigurationProperties withConfigurations(String configurations) {
        if (this.configurationClasses == null) {
            this.configurationClasses = "";
        }
        this.configurationClasses = this.configurationClasses.isEmpty() ? configurations : "," + configurations;
        return this;
    }

    public MainConfigurationProperties withConfigurations(Class<? extends CamelConfiguration> ... configuration) {
        this.addConfigurationClass(configuration);
        return this;
    }

    public MainConfigurationProperties withConfigurations(List<CamelConfiguration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public MainConfigurationProperties withRoutesBuilderClasses(String builders) {
        this.setRoutesBuilderClasses(builders);
        return this;
    }

    public MainConfigurationProperties withRoutesBuilders(List<RoutesBuilder> builders) {
        this.setRoutesBuilders(builders);
        return this;
    }

    public MainConfigurationProperties withAdditionalRoutesBuilder(RoutesBuilder builder) {
        this.addRoutesBuilder(builder);
        return this;
    }

    public MainConfigurationProperties withAdditionalRoutesBuilder(Class ... builders) {
        this.addRoutesBuilder(builders);
        return this;
    }

    public MainConfigurationProperties withAdditionalLambdaRouteBuilder(LambdaRouteBuilder builder) {
        this.addLambdaRouteBuilder(builder);
        return this;
    }
}

