/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.main.MainConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileConfigurer {
    protected static final Logger LOG = LoggerFactory.getLogger(ProfileConfigurer.class);

    public static void configure(CamelContext camelContext, String profile, MainConfigurationProperties config) throws Exception {
        camelContext.getCamelContextExtension().setProfile(profile);
        if (profile == null || profile.isBlank()) {
            return;
        }
        if ("dev".equals(profile)) {
            config.setDevConsoleEnabled(true);
            config.setCamelEventsTimestampEnabled(true);
            config.setLoadHealthChecks(true);
            config.setSourceLocationEnabled(true);
            config.setModeline(true);
            config.setLoadStatisticsEnabled(true);
            config.setMessageHistory(true);
            config.setInflightRepositoryBrowseEnabled(true);
            config.setEndpointRuntimeStatisticsEnabled(true);
            config.setJmxManagementStatisticsLevel(ManagementStatisticsLevel.Extended);
            config.setJmxUpdateRouteEnabled(true);
            config.setShutdownLogInflightExchangesOnTimeout(false);
            config.setShutdownTimeout(10);
            config.setStartupRecorder("backlog");
            config.tracerConfig().withEnabled(true);
        }
        if ("prod".equals(profile)) {
            profile = "production";
        }
        LOG.info("The application is starting with profile: {}", (Object)profile);
    }
}

