/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import java.util.Collection;
import javax.management.openmbean.TabularData;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.mbean.ManagedPerformanceCounterMBean;
import org.apache.camel.api.management.mbean.RouteError;

public interface ManagedRouteMBean
extends ManagedPerformanceCounterMBean {
    @ManagedAttribute(description="Route ID")
    public String getRouteId();

    @ManagedAttribute(description="Node Prefix ID")
    public String getNodePrefixId();

    @ManagedAttribute(description="Route Group")
    public String getRouteGroup();

    @ManagedAttribute(description="Is this route created from a route template (or Kamelet)")
    public boolean isCreatedByRouteTemplate();

    @ManagedAttribute(description="Is this route created from a Kamelet")
    public boolean isCreatedByKamelet();

    @ManagedAttribute(description="Route Properties")
    public TabularData getRouteProperties();

    @ManagedAttribute(description="Route Description")
    public String getDescription();

    @ManagedAttribute(description="Route Source Location")
    public String getSourceLocation();

    @ManagedAttribute(description="Route Source Location (Short)")
    public String getSourceLocationShort();

    @ManagedAttribute(description="Route Configuration ID")
    public String getRouteConfigurationId();

    @ManagedAttribute(description="Route Endpoint URI", mask=true)
    public String getEndpointUri();

    @ManagedAttribute(description="Route State")
    public String getState();

    @ManagedAttribute(description="Route Uptime [human readable text]")
    public String getUptime();

    @ManagedAttribute(description="Route Uptime [milliseconds]")
    public long getUptimeMillis();

    @ManagedAttribute(description="Camel ID")
    public String getCamelId();

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName();

    @ManagedAttribute(description="Tracing")
    public Boolean getTracing();

    @ManagedAttribute(description="Tracing")
    public void setTracing(Boolean var1);

    @ManagedAttribute(description="Message History")
    public Boolean getMessageHistory();

    @ManagedAttribute(description="Whether security mask for Logging is enabled")
    public Boolean getLogMask();

    @ManagedAttribute(description="Route Policy List")
    public String getRoutePolicyList();

    @ManagedAttribute(description="Average load over the last minute")
    public String getLoad01();

    @ManagedAttribute(description="Average load over the last five minutes")
    public String getLoad05();

    @ManagedAttribute(description="Average load over the last fifteen minutes")
    public String getLoad15();

    @ManagedAttribute(description="Throughput message/second")
    public String getThroughput();

    @ManagedOperation(description="Start route")
    public void start() throws Exception;

    @ManagedOperation(description="Stop route")
    public void stop() throws Exception;

    @ManagedOperation(description="Stop and marks the route as failed (health-check reporting as DOWN)")
    public void stopAndFail() throws Exception;

    @ManagedOperation(description="Stop route (using timeout in seconds)")
    public void stop(long var1) throws Exception;

    @ManagedOperation(description="Stop route, abort stop after timeout (in seconds)")
    public boolean stop(Long var1, Boolean var2) throws Exception;

    @ManagedOperation(description="Remove route (must be stopped)")
    public boolean remove() throws Exception;

    @ManagedOperation(description="Restarts route (1 second delay before starting)")
    public void restart() throws Exception;

    @ManagedOperation(description="Restarts route (using delay in seconds before starting)")
    public void restart(long var1) throws Exception;

    @ManagedOperation(description="Dumps the route as XML")
    public String dumpRouteAsXml() throws Exception;

    @ManagedOperation(description="Dumps the route as XML")
    public String dumpRouteAsXml(boolean var1) throws Exception;

    @ManagedOperation(description="Dumps the route as XML")
    public String dumpRouteAsXml(boolean var1, boolean var2) throws Exception;

    @ManagedOperation(description="Dumps the route as YAML")
    public String dumpRouteAsYaml() throws Exception;

    @ManagedOperation(description="Dumps the route as YAML")
    public String dumpRouteAsYaml(boolean var1) throws Exception;

    @ManagedOperation(description="Dumps the route as YAML")
    public String dumpRouteAsYaml(boolean var1, boolean var2) throws Exception;

    @ManagedOperation(description="Dumps the route as YAML")
    public String dumpRouteAsYaml(boolean var1, boolean var2, boolean var3) throws Exception;

    @ManagedOperation(description="Dumps the route stats as XML")
    public String dumpRouteStatsAsXml(boolean var1, boolean var2) throws Exception;

    @ManagedOperation(description="Dumps the route and steps stats as XML")
    public String dumpStepStatsAsXml(boolean var1) throws Exception;

    @ManagedOperation(description="Dumps the route with mappings between node ids and their source location/line-number (currently only XML and YAML routes supported) as XML")
    public String dumpRouteSourceLocationsAsXml() throws Exception;

    @ManagedOperation(description="Reset counters")
    public void reset(boolean var1) throws Exception;

    @ManagedAttribute(description="Oldest inflight exchange duration")
    public Long getOldestInflightDuration();

    @ManagedAttribute(description="Oldest inflight exchange id")
    public String getOldestInflightExchangeId();

    @ManagedAttribute(description="Is using route controller")
    public Boolean getHasRouteController();

    @ManagedAttribute(description="Last error")
    public RouteError getLastError();

    @ManagedOperation(description="IDs for the processors that are part of this route")
    public Collection<String> processorIds() throws Exception;

    @ManagedOperation(description="Updates the route from XML")
    public void updateRouteFromXml(String var1) throws Exception;

    @ManagedAttribute(description="Whether update route from XML is enabled")
    public boolean isUpdateRouteEnabled();

    @ManagedAttribute(description="Whether the consumer connects to remote or local systems")
    public boolean isRemoteEndpoint();
}

