/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CamelChoiceWithManagementTest
extends ContextTestSupport {
    private MockEndpoint a;
    private MockEndpoint b;
    private MockEndpoint c;
    private MockEndpoint d;
    private MockEndpoint e;

    protected boolean useJmx() {
        return true;
    }

    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.a = this.getMockEndpoint("mock:a");
        this.b = this.getMockEndpoint("mock:b");
        this.c = this.getMockEndpoint("mock:c");
        this.d = this.getMockEndpoint("mock:d");
        this.e = this.getMockEndpoint("mock:e");
    }

    @Test
    public void testFirstChoiceRoute() throws Exception {
        String body = "<one/>";
        this.a.expectedBodiesReceived(new Object[]{"<one/>"});
        this.a.expectedHeaderReceived("CBR1", (Object)"Yes");
        this.c.expectedBodiesReceived(new Object[]{"<one/>"});
        this.c.expectedHeaderReceived("CBR1", (Object)"Yes");
        this.c.expectedHeaderReceived("Validation", (Object)"Yes");
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.b, this.d, this.e});
        this.template.send("direct:start", exchange -> {
            exchange.getIn().setBody((Object)"<one/>");
            exchange.getIn().setHeader("CBR1", (Object)"Yes");
        });
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOtherwise() throws Exception {
        String body = "<None/>";
        this.e.expectedBodiesReceived(new Object[]{"<None/>"});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.a, this.b, this.c, this.d});
        this.template.send("direct:start", exchange -> exchange.getIn().setBody((Object)"<None/>"));
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.header("CBR1").isEqualTo((Object)"Yes")).to("mock:a")).setHeader("Validation", (Expression)this.constant("Yes"))).when(this.header("CBR1").isEqualTo((Object)"No")).to("mock:b")).end().choice().when(this.header("Validation").isEqualTo((Object)"Yes")).to("mock:c")).when(this.header("Validation").isEqualTo((Object)"No")).to("mock:d")).otherwise().to("mock:e")).end();
            }
        };
    }
}

