/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.JmxNotificationEventNotifier;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JmxNotificationEventNotifierTest
extends ManagementTestSupport {
    private JmxNotificationEventNotifier notifier;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        this.notifier = new JmxNotificationEventNotifier();
        this.notifier.setSource("MyCamel");
        this.notifier.setIgnoreCamelContextEvents(true);
        this.notifier.setIgnoreRouteEvents(true);
        this.notifier.setIgnoreServiceEvents(true);
        DefaultCamelContext context = new DefaultCamelContext(this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        return context;
    }

    @Test
    public void testExchangeDone() throws Exception {
        ObjectName on = this.getCamelObjectName("eventnotifiers", "JmxEventNotifier");
        MyNotificationListener listener = new MyNotificationListener();
        this.context.getManagementStrategy().getManagementAgent().getMBeanServer().addNotificationListener(on, listener, new NotificationFilter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNotificationEnabled(Notification notification) {
                return notification.getSource().equals("MyCamel");
            }
        }, null);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)8, (int)listener.getEventCounter(), (String)"Get a wrong number of events");
        this.context.stop();
    }

    @Test
    public void testExchangeFailed() throws Exception {
        ObjectName on = this.getCamelObjectName("eventnotifiers", "JmxEventNotifier");
        MyNotificationListener listener = new MyNotificationListener();
        this.context.getManagementStrategy().getManagementAgent().getMBeanServer().addNotificationListener(on, listener, new NotificationFilter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNotificationEnabled(Notification notification) {
                return true;
            }
        }, null);
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            JmxNotificationEventNotifierTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
        }
        Assertions.assertEquals((int)4, (int)listener.getEventCounter(), (String)"Get a wrong number of events");
        this.context.stop();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:fail").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }

    private class MyNotificationListener
    implements NotificationListener {
        private int eventCounter;

        private MyNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            JmxNotificationEventNotifierTest.this.log.debug("Get the notification : " + notification);
            ++this.eventCounter;
        }

        public int getEventCounter() {
            return this.eventCounter;
        }
    }
}

